namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_41
{
    public class BinaryConverter
    {
        public static void Main()
        {
            const int size = 64;
            ulong value;
            char bit;

            System.Console.Write("Wprowad liczb cakowit: ");
            // Wywoanie long.Parse() pozwala doda obsug liczb ujemnych.
            // Kod bez sprawdzania przypisuje warto do zmiennej typu ulong.
            value = (ulong)long.Parse(System.Console.ReadLine());

            // Ustawianie pocztkowej maski na 100.
            ulong mask = 1UL << size - 1;
            for (int count = 0; count < size; count++)
            {
                bit = ((mask & value) != 0) ? '1' : '0';
                System.Console.Write(bit);
                // Przesunicie maski o jedn pozycj w prawo.
                mask >>= 1;
            }
            System.Console.WriteLine();
        }
    }
}
