namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter19.Listing19_18
{
    using System;
    using System.IO;
    using System.Net;
    using System.Linq;
    using System.Threading.Tasks;

    public class Program
    {

        public static void Main(string[] args)
        {
            string url = "http://www.IntelliTect.com";
            if(args.Length > 0)
            {
                url = args[0];
            }

            Console.Write(url);

            Func<string, Task> writeWebRequestSizeAsync =
                async (string webRequestUrl) =>
                {
                    // Obsug bdw pominito, by
                    // kod by bardziej zrozumiay.
                    WebRequest webRequest =
                       WebRequest.Create(url);

                    WebResponse response =
                        await webRequest.GetResponseAsync();
                    using(StreamReader reader =
                        new StreamReader(
                            response.GetResponseStream()))
                    {
                        string text =
                            (await reader.ReadToEndAsync());
                        Console.WriteLine(
                            FormatBytes(text.Length));
                    }
                };

            Task task = writeWebRequestSizeAsync(url);

            while(!task.Wait(100))
            {
                Console.Write(".");
            }
        }

        static public string FormatBytes(long bytes)
        {
            string[] magnitudes =
                new string[] { "GB", "MB", "KB", "bajtw" };
            long max =
                (long)Math.Pow(1024, magnitudes.Length);

            return string.Format("{1:##.##} {0}",
                magnitudes.FirstOrDefault(
                    magnitude =>
                        bytes > (max /= 1024)) ?? "0 bajtw",
                    (decimal)bytes / (decimal)max).Trim();
        }
    }
}





