﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter19.Listing19_06
{
    using System;
    using System.Diagnostics;
    using System.Threading.Tasks;
    using AddisonWesley.Michaelis.EssentialCSharp.Shared;

    public class Program
    {
        public static void Main()
        {
            // Aby zastosować bibliotekę TPL w wersjach starszych niż .NET 4.5, 
            // wywołaj metodę Task.Factory.StartNew<string>().
            Task<string> task =
                Task.Run<string>(
                    () => PiCalculator.Calculate(10));
            Task faultedTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    if(!antecedentTask.IsFaulted)
                    {
                        throw new Exception("Oczekiwany stan zadania poprzedzającego: Faulted");
                    }
                    Console.WriteLine(
                        "Stan zadania: Faulted");
                },
                TaskContinuationOptions.OnlyOnFaulted);

            Task canceledTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    if (!antecedentTask.IsCanceled)
                    {
                        throw new Exception("Oczekiwany stan zadania poprzedzającego: Canceled");
                    }
                    Console.WriteLine(
                        "Stan zadania: Canceled");
                },
                TaskContinuationOptions.OnlyOnCanceled);

            Task completedTask = task.ContinueWith(
                (antecedentTask) =>
                {
                    if (!antecedentTask.IsCompleted)
                    {
                        throw new Exception("Oczekiwany stan zadania poprzedzającego: Completed");
                    }
                    Console.WriteLine(
                        "Stan zadania: Completed");
                }, TaskContinuationOptions.
                        OnlyOnRanToCompletion);

            completedTask.Wait();

        }

    }
}





