﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Linq;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_13.Tests
{

    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void SelectingAnonymousTypeFollowingGroupClause()
        {
            // Do określenia wyników celowo używana jest 
            // instrukcja inna niż select.
            string expected = Program.Keywords.Aggregate("",
                (string result, string word) => {
                    var splitCharactersOntoEachLine = word.Aggregate("",
                (string wordResult, char character) =>
                    wordResult + character + Environment.NewLine);
                    return result + splitCharactersOntoEachLine;
            });

            string nl = Environment.NewLine;
            Assert.IsTrue(
                expected.StartsWith($"a{nl}b{nl}s{nl}t{nl}r{nl}a{nl}c{nl}t{nl}a"));
            Assert.IsTrue(
                expected.EndsWith($"e{nl}y{nl}i{nl}e{nl}l{nl}d{nl}*{nl}"));


            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                Program.Main();
            });
        }
    }
}