﻿using System;
using static System.Console;
using CS7;
using System.Xml.Linq;
using Microsoft.EntityFrameworkCore;
using System.Linq;

namespace LinqZEFCore
{
   class Program
   {
      static void Main(string[] args)
      {
         using (var db = new Northwind())
         {
            var zapytanie = db.Products
            .PrzetwarzajSekwencje()
            .Where(produkt => produkt.UnitPrice < 10M)
            .OrderByDescending(produkt => produkt.UnitPrice)
            .Select(produkt => new
            {
               produkt.ProductID,
               produkt.ProductName,
               produkt.UnitPrice
            });
            WriteLine("Produkty kosztujące mniej niż 10$:");
            foreach (var pozycja in zapytanie)
            {
               WriteLine($"{pozycja.ProductID}: {pozycja.ProductName} kosztuje {pozycja.UnitPrice:$#,##0.00}");
            }
            WriteLine();




            // utwórz dwie sekwencje, które zostaną złączone
            var kategorie = db.Categories.Select(
            k => new { k.CategoryID, k.CategoryName }).ToArray();

            var produkty = db.Products.Select(
            p => new
            {
               p.ProductID,
               p.ProductName,
               p.CategoryID
            }).ToArray();

            // złącz każdy produkt z odpowiednią kategorią i zwróć 77 dopasowań
            var zapytanieJoin = kategorie.Join(produkty,
            kategoria => kategoria.CategoryID,
            produkt => produkt.CategoryID,
            (c, p) => new
            {
               c.CategoryName,
               p.ProductName,
               p.ProductID
            });

            foreach (var pozycja in zapytanieJoin)
            {
               WriteLine($"{pozycja.ProductID}: {pozycja.ProductName} w kategorii {pozycja.CategoryName}.");
            }




            // zgrupuj wszystkie produkty według kategorii i wypisz 8 grup
            var zapytanieGroup = kategorie.GroupJoin(produkty,
            kategoria => kategoria.CategoryID,
            produkt => produkt.CategoryID,
            (k, Produkty) => new
            {
               k.CategoryName,
               Produkty = Produkty.OrderBy(p => p.ProductName)
            });
            foreach (var element in zapytanieGroup)
            {
               WriteLine($"Kategoria {element.CategoryName} ma {element.Produkty.Count()} produktów.");
               foreach (var produkt in element.Produkty)
               {
                  WriteLine($" {produkt.ProductName}");
               }
            }




            WriteLine("Produkty");
            WriteLine($" Liczba: {db.Products.Count()}");
            WriteLine($" Sume jednostek w magazynie: {db.Products.Sum(p => p.UnitsInStock):N0}");
            WriteLine($" Suma jednostek w zamówieniach: {db.Products.Sum(p => p.UnitsOnOrder):N0}");
            WriteLine($" Średnia cena jednostki: {db.Products.Average(p => p.UnitPrice):$#,##0.00}");
            WriteLine($" Wartość jednostek w zajmówieniach: {db.Products.Sum(p => p.UnitPrice * p.UnitsInStock):$#,##0.00}");



            WriteLine("Własne metody rozszerzające LINQ:");
            WriteLine($" Średnia liczby jednostek w magazynie: {db.Products.Average(p => p.UnitsInStock):N0}");
            WriteLine($" Średni cena jednostki:{db.Products.Average(p => p.UnitPrice):$#,##0.00}");
            WriteLine($" Mediana liczby jednostek w magazynie:{db.Products.Mediana(p => p.UnitsInStock)}");
            WriteLine($" Mediana ceny jednostek:{db.Products.Mediana(p => p.UnitPrice):$#,##0.00}");
            WriteLine($" Dominanta liczby jednostek w magazynie:{db.Products.Dominanta(p => p.UnitsInStock)}");
            WriteLine($" Dominanta ceny jednostek:{db.Products.Dominanta(p => p.UnitPrice):$#,##0.00}");


            var produktyDlaXml = db.Products.ToArray();
            var xml = new XElement("produkty",
               from p in produktyDlaXml
               select new XElement("produkt",
               new XAttribute("id", p.ProductID),
               new XAttribute("cena", p.UnitPrice),
               new XElement("nazwa", p.ProductName)));

            WriteLine(xml.ToString());




XDocument dokument = XDocument.Load("ustawienia.xml");
var stawieniaAplikacji = dokument.Descendants("appSettings")
   .Descendants("add")
   .Select(wezel => new
{
   Key = wezel.Attribute("key").Value,
   Value = wezel.Attribute("value").Value
}).ToArray();

foreach (var element in stawieniaAplikacji)
{
   WriteLine($"{element.Key}: {element.Value}");
}
         }

      }
   }
}
