﻿using static System.Console;
using System;
using System.Reflection;
using System.Linq;

namespace PracaZRefleksja
{
    class Program
    {
        static void Main(string[] args)
        {
            WriteLine("Metadane zestawu:");
            Assembly zestaw = Assembly.GetEntryAssembly();
            WriteLine($" Nazwa: {zestaw.FullName}");
            WriteLine($" Lokalizacja: {zestaw.Location}");
            var atrybuty = zestaw.GetCustomAttributes();
            WriteLine($" Atrybuty:");
            foreach (Attribute a in atrybuty)
            {
                WriteLine($" {a.GetType()}");
            }

            var wersja = zestaw.GetCustomAttribute<AssemblyInformationalVersionAttribute>();
            WriteLine($" Wersja: {wersja.InformationalVersion}");
            var firma = zestaw.GetCustomAttribute<AssemblyCompanyAttribute>();
            WriteLine($" Firma: {firma.Company}");

            WriteLine($"Typy:");
            Type[] typy = zestaw.GetTypes();
            foreach (Type typ in typy)
            {
                WriteLine($" Nazwa: {typ.FullName}");
                MemberInfo[] elementy = typ.GetMembers();
                foreach (MemberInfo element in elementy)
                {
                    WriteLine($"   {element.MemberType}: {element.Name} ({ element.DeclaringType.Name})");
                    var programisci = element.GetCustomAttributes<ProgramistaAttribute>().OrderByDescending(c => c.OstatnioZmienione);
                    foreach (ProgramistaAttribute programista in programisci)
                    {
                        WriteLine($"     Zmienione przez {programista.Programista} w dniu {programista.OstatnioZmienione.ToShortDateString()}");
                    }
                }
            }

            ReadKey();
        }

        [Programista("Mark Price", "22.08.2017")]
        [Programista("Jan Adamski", "13.09.2017")]
        public static void ZrobCos()
        {
        }
    }
}