﻿using System;
using System.Collections.Generic; // interfejs IEnumerable<T>
using System.Linq; // metody rozszerzające LINQ
using static System.Console;

namespace PracaZeZbiorami
{
   class Program
   {
      private static void Wyjscie(IEnumerable<string> kohorta, string opis = "")
      {
         if (!string.IsNullOrEmpty(opis))
         {
            WriteLine(opis);
         }
         Write(" ");
         WriteLine(string.Join(", ", kohorta.ToArray()));
      }

      static void Main(string[] args)
      {
         OutputEncoding = new System.Text.UTF8Encoding();

         var zespol1 = new string[] { "Rafał", "Grzegorz", "Jan", "Gabrysia" };
         var zespol2 = new string[] { "Jacek", "Stefan", "Daniel", "Jacek", "Janina" };
         var zespol3 = new string[] { "Darek", "Jacek", "Jacek", "Malina", "Celina" };
         Wyjscie(zespol1, "Zespół 1");
         Wyjscie(zespol2, "Zespół 2");
         Wyjscie(zespol3, "Zespół 3");
         WriteLine();
         Wyjscie(zespol2.Distinct(), "zespol2.Distinct(): usuwa duplikaty");
         Wyjscie(zespol2.Union(zespol3), "zespol2.Union(zespol3): łączy zbiory i usuwa duplikaty");
         Wyjscie(zespol2.Concat(zespol3), "zespol2.Concat(zespol3): łączy zbiory, pozostawia duplikaty");
         Wyjscie(zespol2.Intersect(zespol3), "zespol2.Intersect(zespol3): elementy znajdujące się w obu sekwencjach");
         Wyjscie(zespol2.Except(zespol3), "zespol2.Except(zespol3): usuwa z pierwszej sekwencji elementy, które znajdują się w drugiej sekwencji");
         Wyjscie(zespol1.Zip(zespol2, (c1, c2) => $"{c1} przeciw {c2}"), "zespol1.Zip(zespol2, (c1, c2) => $\"{c1} przeciw {c2}\")" + ": dopasowuje elementy na podstawie ich pozycji w sekwencji");

         ReadKey();
      }
   }
}
