﻿using System;
using System.Collections.Generic;
using static System.Console;

namespace CS7
{
    public class Osoba : IComparable<Osoba>
    {
        public string Nazwisko;
        public DateTime DataUrodzenia;
        public List<Osoba> Dzieci;

        public Osoba()
        {
            Dzieci = new List<Osoba>();
        }

        // metody
      public void WypiszWKonsoli()
      {
         WriteLine($"{Nazwisko}, data urodzenia {DataUrodzenia:dddd, d MMMM yyyy}");
      }

        // metody "rozmnażania"
        public static Osoba Prokreacja(Osoba o1, Osoba o2)
        {
            var dziecko = new Osoba
            {
                Nazwisko = $"Dziecko osob {o1.Nazwisko} i {o2.Nazwisko}"
            };
            o1.Dzieci.Add(dziecko);
            o2.Dzieci.Add(dziecko);
            return dziecko;
        }

        public Osoba ProkreacjaZ(Osoba partner)
        {
            return Prokreacja(this, partner);
        }

        // zdarzenie
        public event EventHandler Krzycz;

        // pole
        public int PoziomZlosci;

        // metoda
        public void Szturchnij()
        {
            PoziomZlosci++;
            if (PoziomZlosci >= 3)
            {
                // jeżeli coś słucha zdarzenia…
                if (Krzycz != null)
                {
                    // …to wywołaj zdarzenie
                    Krzycz(this, EventArgs.Empty);
                }
            }
        }

        public int CompareTo(Osoba inna)
        {
            return Nazwisko.CompareTo(inna.Nazwisko);
        }

        public override string ToString()
        {
            return $"{Nazwisko} to {base.ToString()}";
        }
    }
}
