﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using NorthwindMVC.Models;
using CS7;
using Microsoft.EntityFrameworkCore;

namespace NorthwindMVC.Controllers
{
   public class HomeController : Controller
   {
      private Northwind bd;

      public HomeController(Northwind wstrzyknietyKontekst)
      {
         bd = wstrzyknietyKontekst;
      }

      public IActionResult Index()
      {
         var model = new HomeIndexViewModel
         {
            LiczbaOdwiedzin = (new Random()).Next(1, 1001),
            Kategorie = bd.Categories.ToList(),
            Produkty = bd.Products.ToList()
         };
         return View(model); // przekazanie modelu do widoku
      }

      public IActionResult About()
      {
         ViewData["Message"] = "Your application description page.";

         return View();
      }

      public IActionResult Contact()
      {
         ViewData["Message"] = "Your contact page.";

         return View();
      }

      public IActionResult Error()
      {
         return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
      }

      public IActionResult ProductDetail(int? id)
      {
         if (!id.HasValue)
         {
            return NotFound("Musisz podać w ścieżce ID produktu, na przykład: /Home/ProductDetail/21");
         }
         var model = bd.Products.SingleOrDefault(p => p.ProductID == id);
         if (model == null)
         {
            return NotFound($"Nie znaleziono produktu o identyfikatorze {id}.");
         }
         return View(model); // przekazanie modelu do widoku
      }

      public IActionResult ProduktyDrozszeNiz(decimal? cena)
      {
         if (!cena.HasValue)
         {
            return NotFound("Cenę produktu musisz podać w ciągu znaków zapytania! Na przykład: /Home/ProduktyDrozszeNiz?cena=50");
         }
         var model = bd.Products.Include(p => p.Category).Include(
            p => p.Supplier).Where(p => p.UnitPrice > cena).ToArray();
         if (model.Count() == 0)
         {
            return NotFound($"Nie ma produktów droższych niż {cena:C}.");
         }
         ViewData["MaksymalnaCena"] = cena.Value.ToString("C");
         return View(model); // przekazanie modelu do widoku
      }
   }
}
