﻿using System;

using CommonServiceLocator;

using GalaSoft.MvvmLight.Ioc;
using NorthwindFluent;
using NorthwindUWP.Services;
using NorthwindUWP.Views;

namespace NorthwindUWP.ViewModels
{
    [Windows.UI.Xaml.Data.Bindable]
    public class ViewModelLocator
    {
        public ViewModelLocator()
        {
            ServiceLocator.SetLocatorProvider(() => SimpleIoc.Default);

            SimpleIoc.Default.Register(() => new NavigationServiceEx());
            SimpleIoc.Default.Register<ShellViewModel>();
            Register<MainViewModel, MainPage>();
            Register<AngularWebViewViewModel, AngularWebViewPage>();
            Register<KlienciDataGridViewModel, KlienciDataGridPage>();
            Register<KategorieMasterDetailViewModel, KategorieMasterDetailPage>();
            Register<KlienciMapViewModel, KlienciMapPage>();
            Register<SettingsViewModel, SettingsPage>();
        }

        public SettingsViewModel SettingsViewModel => ServiceLocator.Current.GetInstance<SettingsViewModel>();

        public KlienciMapViewModel KlienciMapViewModel => ServiceLocator.Current.GetInstance<KlienciMapViewModel>();

        public KategorieMasterDetailViewModel KategorieMasterDetailViewModel => ServiceLocator.Current.GetInstance<KategorieMasterDetailViewModel>();

        public KlienciDataGridViewModel KlienciDataGridViewModel => ServiceLocator.Current.GetInstance<KlienciDataGridViewModel>();

        public AngularWebViewViewModel AngularWebViewViewModel => ServiceLocator.Current.GetInstance<AngularWebViewViewModel>();

        public MainViewModel MainViewModel => ServiceLocator.Current.GetInstance<MainViewModel>();

        public ShellViewModel ShellViewModel => ServiceLocator.Current.GetInstance<ShellViewModel>();

        public NavigationServiceEx NavigationService => ServiceLocator.Current.GetInstance<NavigationServiceEx>();

        public void Register<VM, V>()
            where VM : class
        {
            SimpleIoc.Default.Register<VM>();

            NavigationService.Configure(typeof(VM).FullName, typeof(V));
        }
    }
}
