﻿using System;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace NorthwindFluent
{
   public sealed partial class MainPage : Page
   {
      public MainPage()
      {
         this.InitializeComponent();
      }

      private void NawigacjaView_Loaded(object sender, RoutedEventArgs e)
      {
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Kategorie",
            Icon = new SymbolIcon(Symbol.BrowsePhotos),
            Tag = "kategorie"
         });
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Produkty",
            Icon = new SymbolIcon(Symbol.AllApps),
            Tag = "produkty"
         });
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Dostawcy",
            Icon = new SymbolIcon(Symbol.Contact2),
            Tag = "dostawcy"
         });
         NawigacjaView.MenuItems.Add(new NavigationViewItemSeparator());
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Klienci",
            Icon = new SymbolIcon(Symbol.People),
            Tag = "klienci"
         });
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Zamówienia",
            Icon = new SymbolIcon(Symbol.PhoneBook),
            Tag = "zamowienia"
         });
         NawigacjaView.MenuItems.Add(new NavigationViewItem
         {
            Content = "Spedytorzy",
            Icon = new SymbolIcon(Symbol.PostUpdate),
            Tag = "spedytorzy"
         });
      }

      private void NawigacjaView_ItemInvoked(NavigationView sender, NavigationViewItemInvokedEventArgs args)
      {
         switch (args.InvokedItem.ToString())
         {
            case "Kategorie":
               TrescFrame.Navigate(typeof(KategoriePage));
               break;
            default:
               TrescFrame.Navigate(typeof(BezImplementacjiPage));
               break;
         }
      }

      private async void OdswiezButton_Click(object sender, RoutedEventArgs e)
      {
         var notImplementedDialog = new ContentDialog
         {
            Title = "Nie zaimplementowane",
            Content = "Funkcja odświeżania nie została jeszcze zaimplementowana.",
            CloseButtonText = "OK"
         };
         ContentDialogResult result = await notImplementedDialog.ShowAsync();
      }
   }
}