﻿using CS7;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net.Http;
using System.Runtime.Serialization.Json;

namespace NorthwindFluent
{
   public class KategorieViewModel
   {
      public class KategoriaJson
      {
         public int categoryID;
         public string categoryName;
         public string description;
      }

      public ObservableCollection<Category> Kategorie { get; set; }

      public KategorieViewModel()
      {
         using (var http = new HttpClient())
         {
            http.BaseAddress = new Uri("http://localhost:5001/");
            var serializer = new DataContractJsonSerializer(typeof(List<KategoriaJson>));
            var resp = http.GetStreamAsync("api/kategorie");
            var strumien = resp.Result;
            var listaKategorii = serializer.ReadObject(strumien) as List<KategoriaJson>;
            var kategorie = listaKategorii.Select(c => new Category
            {
               CategoryID = c.categoryID,
               CategoryName = c.categoryName,
               Description = c.description
            });
            Kategorie = new ObservableCollection<Category>(kategorie);
         }
      }
   }
}