var log = require('./logger').create()

var Executor = function (capturedBrowsers, config, emitter) {
  var self = this
  var executionScheduled = false
  var pendingCount = 0
  var runningBrowsers

  var schedule = function () {
    var nonReady = []

    if (!capturedBrowsers.length) {
      log.warn('No captured browser, open %s//%s:%s%s', config.protocol, config.hostname,
        config.port, config.urlRoot)
      return false
    }

    if (capturedBrowsers.areAllReady(nonReady)) {
      log.debug('All browsers are ready, executing')
      log.debug('Captured %s browsers', capturedBrowsers.length)
      executionScheduled = false
      capturedBrowsers.clearResults()
      capturedBrowsers.setAllToExecuting()
      pendingCount = capturedBrowsers.length
      runningBrowsers = capturedBrowsers.clone()
      emitter.emit('run_start', runningBrowsers)
      self.socketIoSockets.emit('execute', config.client)
      return true
    }

    log.info('Delaying execution, these browsers are not ready: ' + nonReady.join(', '))
    executionScheduled = true
    return false
  }

  this.schedule = schedule

  this.onRunComplete = function () {
    if (executionScheduled) {
      schedule()
    }
  }

  this.onBrowserComplete = function () {
    pendingCount--

    if (!pendingCount) {
      // Ensure run_complete is emitted in the next tick
      // so it is never emitted before browser_complete
      setTimeout(function () {
        emitter.emit('run_complete', runningBrowsers, runningBrowsers.getResults())
      }, 0)
    }
  }

  // bind all the events
  emitter.bind(this)
}

module.exports = Executor
