﻿using Microsoft.EntityFrameworkCore.ChangeTracking;
using CS7;
using System.Collections.Generic;
using System.Collections.Concurrent;
using System.Linq;
using System.Threading.Tasks;

namespace SerwisNorthwind.Repozytoria
{
   public class RepozytoriumCustomer : IRepozytoriumCustomer
   {
      // dane klientów umieszczane są w wielowątkowym słowniku
      // co bardzo poprawi szybkość pracy
      private static ConcurrentDictionary<string, Customer> pamiecPodreczna;
      private Northwind bd;

      public RepozytoriumCustomer(Northwind bd)
      {
         this.bd = bd;
         // Załaduj dane klientów z bazy danych i umieść je 
         // w słowniku, którego kluczem jest ID klienta.
         // Następnie przekształć słownik w wielowątkowy obiekt
         // ConcurrentDictionary
         if (pamiecPodreczna == null)
         {
            pamiecPodreczna = new ConcurrentDictionary<string, Customer>(bd.Customers.ToDictionary(c => c.CustomerID));
         }
      }
      public async Task<Customer> UtworzAsync(Customer k)
      {
         // Normalizowanie ID klienta - tylko wielkie litery
         k.CustomerID = k.CustomerID.ToUpper();
         // dodaj do bazy danych używając EF Core
         EntityEntry<Customer> dodane = await bd.Customers.AddAsync(k);
         int zmienione = await bd.SaveChangesAsync();
         if (zmienione == 1)
         {
            // Jeżeli to nowy klient, to dodaj go do pamięci podręcznej,
            // inaczej wywołaj metodę AktualizujPamiecPodreczna
            return pamiecPodreczna.AddOrUpdate(k.CustomerID, k, AktualizujPamiecPodrecza);
         }
         else
         {
            return null;
         }
      }
      public async Task<IEnumerable<Customer>> OdczytajWszystkoAsync()
      {
         // pobierz z pamięci podręcznej. Tak jest szybciej
         return await Task.Run<IEnumerable<Customer>>(() => pamiecPodreczna.Values);
      }

      public async Task<Customer> OdczytajAsync(string id)
      {
         return await Task.Run(() =>
         {
         // pobierz z pamięci podręcznej. Tak jest szybciej
         id = id.ToUpper();
         Customer k;
         pamiecPodreczna.TryGetValue(id, out k);
            return k;
         });
      }

      private Customer AktualizujPamiecPodrecza(string id, Customer k)
      {
         Customer old;
         if (pamiecPodreczna.TryGetValue(id, out old))
         {
            if (pamiecPodreczna.TryUpdate(id, k, old))
            {
               return k;
            }
         }
         return null;
      }

      public async Task<Customer> AktualizujAsync(string id, Customer k)
      {
         return await Task.Run(() =>
         {
            // normalizowanie id klienta
            id = id.ToUpper();
            k.CustomerID = k.CustomerID.ToUpper();
            // zaktualizuj w bazie danych
            bd.Customers.Update(k);
            int zmienione = bd.SaveChanges();
            if (zmienione == 1)
            {
               // zaktualizuj w pamięci podręcznej
               return Task.Run(() => AktualizujPamiecPodrecza(id, k));
            }
            return null;
         });
      }

      public async Task<bool> UsunAsync(string id)
      {
         return await Task.Run(() =>
         {
         id = id.ToUpper();
         // usuń z bazy danych
         Customer k = bd.Customers.Find(id);
         bd.Customers.Remove(k);
         int zmienione = bd.SaveChanges();
            if (zmienione == 1)
            {
               // usuń z pamięci podręcznej
               return Task.Run(() => pamiecPodreczna.TryRemove(id, out k));
            }
            else
            {
               return null;
            }
         });
      }
   }
}