static void Main()
{
  ListenAsync();                           // Uruchomienie serwera.
  WebClient wc = new WebClient();          // Wykonanie żądania klienta.
  Console.WriteLine (wc.DownloadString
    ("http://localhost:51111/MyApp/Request.txt"));
}

async static void ListenAsync()
{
  HttpListener listener = new HttpListener();
  listener.Prefixes.Add ("http://localhost:51111/MyApp/");  // Serwer nasłuchuje
  listener.Start();                                         // na porcie 51111.

  // Wykonanie żądania klienta
  HttpListenerContext context = await listener.GetContextAsync();

  // Udzielenie odpowiedzi na żądanie.
  string msg = "Prosiłeś o " + context.Request.RawUrl;
  context.Response.ContentLength64 = Encoding.UTF8.GetByteCount (msg);
  context.Response.StatusCode = (int) HttpStatusCode.OK;

  using (Stream s = context.Response.OutputStream)
  using (StreamWriter writer = new StreamWriter (s))
    await writer.WriteAsync (msg);

  listener.Stop();
}