class Test : IDisposable
{
  public void Dispose()             // NIE jest wirtualna.
  {
    Dispose (true);
    GC.SuppressFinalize (this);     // Uniemożliwia wywołanie finalizatora.
  }

  protected virtual void Dispose (bool disposing)
  {
    if (disposing)
    {
      // Wywołanie metody Dispose() w innych obiektach, których właścicielem jest ten egzemplarz.
      // W tym miejscu można odwołać się do innych obiektów zawierających finalizatory.
      // ...
    }

    // Zwolnienie niezarządzanych zasobów, których właścicielem jest (jedynie) ten obiekt.
    // ...
  }

  ˜Test()
  {
    Dispose (false);
  }
}