﻿#region Odczytywanie wszystkich zmiennych środowiskowych

TytulSekcji("Odczytywanie zmiennych środowiskowych procesu");
IDictionary zmienne = GetEnvironmentVariables();
SlownikDoTabeli(zmienne);

TytulSekcji("Odczytywanie zmiennych środowiskowych komputera");
IDictionary zmienneKomputera = GetEnvironmentVariables(
  EnvironmentVariableTarget.Machine);
SlownikDoTabeli(zmienneKomputera);

TytulSekcji("Odczytywanie zmiennych środowiskowych użytkownika");
IDictionary zmienneUzytkownika = GetEnvironmentVariables(
  EnvironmentVariableTarget.User);
SlownikDoTabeli(zmienneUzytkownika);

#endregion

#region Rozwijanie zmiennych środowiskowych

string mojKomputer = "Moja nazwa użytkownika to %USERNAME%. Mój procesor to %PROCESSOR_IDENTIFIER%.";

WriteLine(ExpandEnvironmentVariables(mojKomputer));

#endregion

#region Ustalanie i odczytywanie zmiennej środowiskowej

string klucz_hasla = "MOJE_HASLO";

SetEnvironmentVariable(klucz_hasla, "Ha$l0");

string? haslo = GetEnvironmentVariable(klucz_hasla);

WriteLine($"{klucz_hasla}: {haslo}");

string klucz_sekretu = "MOJ_SEKRET";

string? sekret = GetEnvironmentVariable(klucz_sekretu, EnvironmentVariableTarget.Process);
WriteLine($"Proces     - {klucz_sekretu}: {sekret}");

sekret = GetEnvironmentVariable(klucz_sekretu, EnvironmentVariableTarget.Machine);
WriteLine($"Komputer   - {klucz_sekretu}: {sekret}");

sekret = GetEnvironmentVariable(klucz_sekretu, EnvironmentVariableTarget.User);
WriteLine($"Użytkownik - {klucz_sekretu}: {sekret}");

#endregion
