﻿using System.Text.RegularExpressions;

#region Sprawdzanie cyfr podanych jako tekst

Write("Podaj swój wiek: ");
string wejscie = ReadLine()!;

Regex kontrolaWieku = new(@"^\d+$");

if (kontrolaWieku.IsMatch(wejscie))
{
   WriteLine("Dziękuję!");
}
else
{
   WriteLine($"To nie jest prawidłowy wiek: {wejscie}");
}

#endregion

#region Dzielenie złożonego ciągu znaków z przecinkami

// W C# od 1 do 10 trzeba oznaczać każdy cudzysłów w tekście
//string filmy = "\"Złap mnie, jeśli potrafisz\",\"Kocha, lubi, szanuje\",\"Ja, robot\"";

// W C# 11 i nowszych: Używamy potrójnego cudzysłowu, aby wpisać literał surowego ciągu znaków
string filmy = """
"Złap mnie, jeśli potrafisz","Kocha, lubi, szanuje","Ja, robot"
""";

WriteLine($"Filmy do podziału: {filmy}");

string[] filmyProstyPodzial = filmy.Split(',');

WriteLine("Próba podziału metodą String.Split:");
foreach (string film in filmyProstyPodzial)
{
   WriteLine(film);
}

WriteLine();

var csv = new Regex("(?:^|,)(?=[^\"]|(\")?)\"?((?(1)[^\"]*|[^,\"]*))\"?(?=,|$)");

MatchCollection filmySprytnyPodzial = csv.Matches(filmy);

WriteLine("Próba podziału za pomocą wyrażenia regularnego:");
foreach (Match film in filmySprytnyPodzial)
{
   WriteLine(film.Groups[2].Value);
}

#endregion