using Microsoft.AspNetCore.Mvc.RazorPages; // PageModel.
using Microsoft.EntityFrameworkCore; // Metoda Include.
using Northwind.ModeleEncji; // Customer.

namespace Northwind.Web.Pages;

public class ZamowieniaKlientaModel : PageModel
{
  public Customer? Customer;

  private KontekstNorthwind _db;

  public ZamowieniaKlientaModel(KontekstNorthwind db)
  {
    _db = db;
  }

  public void OnGet()
  {
    string? id = HttpContext.Request.Query["id"];

    Customer = _db.Customers.Include(c => c.Orders)
      .SingleOrDefault(c => c.CustomerId == id);
  }
}
