#region Importowanie przestrzeni nazw
using Microsoft.AspNetCore.Identity; // IdentityUser.
using Microsoft.EntityFrameworkCore; // UseSqlServer.
using Northwind.Mvc.Data; // ApplicationDbContext.
using Northwind.ModeleEncji; // DodajKontekstNorthwind.
using System.Net.Http.Headers; // MediaTypeWithQualityHeaderValue.
using System.Net; // HttpVersion.
#endregion

#region Konfigurowanie serwera WWW i jego serwisów
var tworcaAplikacji = WebApplication.CreateBuilder(args);

// Dodaj serwisy do kontenera.
var polaczenie = tworcaAplikacji.Configuration
  .GetConnectionString("DefaultConnection") ??
  throw new InvalidOperationException(
    "Nie znaleziono połączenia 'DefaultConnection'.");

tworcaAplikacji.Services.AddDbContext<ApplicationDbContext>(opcje =>
    opcje.UseSqlServer(polaczenie)); // lub UseSqlite.

tworcaAplikacji.Services.AddDatabaseDeveloperPageExceptionFilter();

tworcaAplikacji.Services.AddDefaultIdentity<IdentityUser>(opcje =>
  opcje.SignIn.RequireConfirmedAccount = true)
  .AddRoles<IdentityRole>() // Włącz zarządzanie rolami.
  .AddEntityFrameworkStores<ApplicationDbContext>();

tworcaAplikacji.Services.AddControllersWithViews();

// Jeżeli używasz SQLite, domyślnie używany jest plik "..\Northwind.db".
tworcaAplikacji.Services.DodajKontekstNorthwind();

/*
// Jeżeli używasz serwera SQL Server.
string? polaczenieSqlServer = builder.Configuration
  .GetConnectionString("NorthwindConnection");

if (polaczenieSqlServer is null)
{
  Console.WriteLine("Brak danych połączenia z serwerem SQL Server!");
}
else
{
  // Jeżeli używasz uwierzytelniania SQL Server, to wyłącz
  // uwierzytelnianie systemu Windows i wprowadź nazwę i hasło użytkownika.
  Microsoft.Data.SqlClient.SqlConnectionStringBuilder sql = 
    new(polaczenieSqlServer);

  sql.IntegratedSecurity = false;
  sql.UserID = Environment.GetEnvironmentVariable("MY_SQL_USR");
  sql.Password = Environment.GetEnvironmentVariable("MY_SQL_PWD");

  builder.Services.DodajKontekstNorthwind(sql.ConnectionString);
}
*/

tworcaAplikacji.Services.AddOutputCache(opcje =>
{
  opcje.DefaultExpirationTimeSpan = TimeSpan.FromSeconds(20);
  opcje.AddPolicy("views", p => p.SetVaryByQuery("alertstyle"));
});

tworcaAplikacji.Services.AddHttpClient(name: "Northwind.WebApi",
  configureClient: opcje =>
  {
    opcje.DefaultRequestVersion = HttpVersion.Version30;
    opcje.DefaultVersionPolicy = HttpVersionPolicy.RequestVersionExact;

    opcje.BaseAddress = new Uri("https://localhost:5151/");
    opcje.DefaultRequestHeaders.Accept.Add(
      new MediaTypeWithQualityHeaderValue(
      mediaType: "application/json", quality: 1.0));
  });

tworcaAplikacji.Services.AddHttpClient(name: "Northwind.MinimalApi",
  configureClient: opcje =>
  {
    opcje.BaseAddress = new Uri("http://localhost:5152/");
    opcje.DefaultRequestHeaders.Accept.Add(
      new MediaTypeWithQualityHeaderValue(
      "application/json", 1.0));
  }); 

var app = tworcaAplikacji.Build();

#endregion

#region Konfigurowanie potoku żądań HTTP.

if (app.Environment.IsDevelopment())
{
  app.UseMigrationsEndPoint();
}
else
{
  app.UseExceptionHandler("/Home/Error");
  // Domyślną wartością HSTS jest 30 sni. Lepiej jest zmieniać tę wartość w rozwiązaniach produkcyjnych, zobacz https://aka.ms/aspnetcore-hsts.
  app.UseHsts();
}

app.UseHttpsRedirection();
app.UseStaticFiles();

app.UseRouting();

app.UseAuthorization();

app.UseOutputCache();

app.MapControllerRoute(
    name: "default",
    pattern: "{controller=Home}/{action=Index}/{id?}");
//  .CacheOutput(policyName: "views");

app.MapRazorPages();

app.MapGet("/notcached", () => DateTime.Now.ToString());
app.MapGet("/cached", () => DateTime.Now.ToString()).CacheOutput();

#endregion

#region Uruchomienie serwera WWW i nasłuchiwanie żądań HTTP.
app.Run();  // Wywołanie blokujące.
#endregion
