﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;

namespace Northwind.ModeleEncji;

public partial class KontekstNorthwind : DbContext
{
  public KontekstNorthwind()
  {
  }

  public KontekstNorthwind(DbContextOptions<KontekstNorthwind> opcje)
      : base(opcje)
  {
  }

  public virtual DbSet<Category> Categories { get; set; }

  public virtual DbSet<Customer> Customers { get; set; }

  public virtual DbSet<Employee> Employees { get; set; }

  public virtual DbSet<EmployeeTerritory> EmployeeTerritories { get; set; }

  public virtual DbSet<Order> Orders { get; set; }

  public virtual DbSet<OrderDetail> OrderDetails { get; set; }

  public virtual DbSet<Product> Products { get; set; }

  public virtual DbSet<Shipper> Shippers { get; set; }

  public virtual DbSet<Supplier> Suppliers { get; set; }

  public virtual DbSet<Territory> Territories { get; set; }

  protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
  {
    if (!optionsBuilder.IsConfigured)
    {
      string bazaDanych = "Northwind.db";
      string katalog = Environment.CurrentDirectory;
      string sciezka = string.Empty;

      if (katalog.EndsWith("net8.0"))
      {
        // W katalogu <projekt>\bin\<Debug|Release>\net8.0.
        sciezka = Path.Combine("..", "..", "..", "..", bazaDanych);
      }
      else
      {
        // W katalogu <projekt>.
        sciezka = Path.Combine("..", bazaDanych);
      }

      sciezka = Path.GetFullPath(sciezka); // Konwersja na ścieżkę bezwzględną.

      try
      {
        ProtokolKontekstuNorthwind.WriteLine($"Ścieżka bazy danych: {sciezka}");
      }
      catch (Exception ex)
      {
        WriteLine(ex.Message);
      }

      if (!File.Exists(sciezka))
      {
        throw new FileNotFoundException(
          message: $"Nie znaleziono {sciezka}.", fileName: sciezka);
      }

      optionsBuilder.UseSqlite($"Data Source={sciezka}");

      optionsBuilder.LogTo(ProtokolKontekstuNorthwind.WriteLine,
        new[] { Microsoft.EntityFrameworkCore
          .Diagnostics.RelationalEventId.CommandExecuting });
    }
  }

  protected override void OnModelCreating(ModelBuilder modelBuilder)
  {
    modelBuilder.Entity<Order>(encja =>
    {
      encja.Property(e => e.Freight).HasDefaultValueSql("0");
    });

    modelBuilder.Entity<OrderDetail>(encja =>
    {
      encja.Property(e => e.Quantity).HasDefaultValueSql("1");
      encja.Property(e => e.UnitPrice).HasDefaultValueSql("0");

      encja.HasOne(d => d.Order).WithMany(p => 
        p.OrderDetails).OnDelete(DeleteBehavior.ClientSetNull);

      encja.HasOne(d => d.Product).WithMany(p => 
        p.OrderDetails).OnDelete(DeleteBehavior.ClientSetNull);
    });

    modelBuilder.Entity<Product>(encja =>
    {
      encja.Property(e => e.Discontinued).HasDefaultValueSql("0");
      encja.Property(e => e.ReorderLevel).HasDefaultValueSql("0");
      encja.Property(e => e.UnitPrice).HasDefaultValueSql("0");
      encja.Property(e => e.UnitsInStock).HasDefaultValueSql("0");
      encja.Property(e => e.UnitsOnOrder).HasDefaultValueSql("0");

      encja.Property(product => product.UnitPrice)
        .HasConversion<double>();
    });

    OnModelCreatingPartial(modelBuilder);
  }

  partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
