﻿#region Używanie indeksów, zakresów i typu Span

string imieInazwisko = "Wiktoria Nowak";

// Wyznaczenie długości imienia i nazwiska
int dlugoscImienia = imieInazwisko.IndexOf(' ');
int dlugoscNazwiska = imieInazwisko.Length - dlugoscImienia - 1;

// Użycie metody Substring
string imie = imieInazwisko.Substring(
  startIndex: 0,
  length: dlugoscImienia);

string nazwisko = imieInazwisko.Substring(
  startIndex: imieInazwisko.Length - dlugoscNazwiska, 
  length: dlugoscNazwiska);

WriteLine($"Imię: {imie}, Nazwisko: {nazwisko}");

// Użycie typu Span
ReadOnlySpan<char> imieInazwiskoSpan = imieInazwisko.AsSpan();
ReadOnlySpan<char> imieSpan = imieInazwiskoSpan[0..dlugoscImienia];
ReadOnlySpan<char> nazwiskoSpan = imieInazwiskoSpan[^dlugoscNazwiska..^0];

WriteLine("Imię: {0}, Nazwisko: {1}",
  arg0: imieSpan.ToString(),
  arg1: nazwiskoSpan.ToString());

#endregion    

