﻿using Microsoft.Data.SqlClient; // SqlConnectionStringBuilder.
using Microsoft.EntityFrameworkCore; // Metoda UseSqlServer .
using Microsoft.Extensions.DependencyInjection; // IServiceCollection.

namespace Northwind.ModeleEncji;

public static class RozszerzeniaKontekstuNorthwind
{
  /// <summary>
  /// Dodaje kontekst Northwind do podanej kolekcji IServiceCollection. 
  /// Używa dostawcy baz danych SqlServer.
  /// </summary>
  /// <param name="uslugi">Kolekcja usług.</param>
  /// <param name="danePolaczenia">Dane połączenia.</param>
  /// <returns>Kolekcję IServiceCollection, do któej można dodawać kolejne usługi.</returns>
  public static IServiceCollection DodajKontekstNorthwind(
    this IServiceCollection uslugi, 
    string? danePolaczenia = null)
  {
    if (danePolaczenia is null)
    {
      SqlConnectionStringBuilder konfigurator = new();

      konfigurator.DataSource = ".";
      konfigurator.InitialCatalog = "Northwind";
      konfigurator.TrustServerCertificate = true;
      konfigurator.MultipleActiveResultSets = true;

      // Chcemy szybciej uzyskać błąd. Domyślny czas to 15 sekund.
      konfigurator.ConnectTimeout = 3;

      // Jeżeli używasz uwierzytelniania Windows.
      konfigurator.IntegratedSecurity = true;

      // Jeżeli używasz uwierzytelniania SQL Server.
      // konfigurator.UserID = Environment.GetEnvironmentVariable("MY_SQL_USR");
      // konfigurator.Password = Environment.GetEnvironmentVariable("MY_SQL_PWD");

      danePolaczenia = konfigurator.ConnectionString;
    }

    uslugi.AddDbContext<KontekstNorthwind>(opcje =>
    {
      opcje.UseSqlServer(danePolaczenia);

      opcje.LogTo(ProtokolKontekstuNorthwind.WriteLine,
        new[] { Microsoft.EntityFrameworkCore
          .Diagnostics.RelationalEventId.CommandExecuting });
    },
    // Rejestrujemy z czasem życia Transient, aby uniknąć problemów
    // ze współbieżnością w projektach Blazor Server.
    contextLifetime: ServiceLifetime.Transient,
    optionsLifetime: ServiceLifetime.Transient);

    return uslugi;
  }
}
