﻿using Northwind.ModeleEncji; // To use Customer.
using System.Net.Http.Json; // To use GetFromJsonAsync.

namespace Northwind.Blazor.Services;

public class KlienckiSerwisNorthwind : ISerwisNorthwind
{
  private readonly HttpClient _http;

  public KlienckiSerwisNorthwind(HttpClient httpClient)
  {
    _http = httpClient;
  }

  public Task<List<Customer>> PobierzKlientowAsync()
  {
    return _http.GetFromJsonAsync
      <List<Customer>>("api/klienci")!;
  }

  public Task<List<Customer>> PobierzKlientowAsync(string kraj)
  {
    return _http.GetFromJsonAsync
      <List<Customer>>($"api/klienci/in/{kraj}")!;
  }

  public Task<Customer?> PobierzKlientaAsync(string id)
  {
    return _http.GetFromJsonAsync
      <Customer>($"api/klienci/{id}");
  }

  public async Task<Customer>
    UtworzKlientaAsync(Customer k)
  {
    HttpResponseMessage odpowiedz = await
      _http.PostAsJsonAsync("api/klienci", k);

    return (await odpowiedz.Content
      .ReadFromJsonAsync<Customer>())!;
  }

  public async Task<Customer> AktualizujKlientaAsync(Customer k)
  {
    HttpResponseMessage odpowiedz = await
      _http.PutAsJsonAsync("api/klienci", k);

    return (await odpowiedz.Content
      .ReadFromJsonAsync<Customer>())!;
  }

  public async Task UsunKlientaAsync(string id)
  {
    HttpResponseMessage response = await
      _http.DeleteAsync($"api/klienci/{id}");
  }
}
