﻿using System.Collections.Generic;

namespace System.Linq
{ 
   public static class RozszerzeniaLinq
   {
     // Tę metodę rozszerzającą można łączyć w łańcuch wywołań.
     public static IEnumerable<T> PrzetwarzajSekwencje<T>(
       this IEnumerable<T> sekwencja)
     {
       // Tu możesz realizować jakieś operacje.
       return sekwencja;
     }

     public static IQueryable<T> PrzetwarzajSekwencje<T>(
       this IQueryable<T> sekwencja)
     {
       // Tu możesz realizować jakieś operacje.
       return sekwencja;
     }

     
     public static int? Mediana(
       this IEnumerable<int?> sekwencja)
     {
       var uporzadkowane = sekwencja.OrderBy(element => element);
       int pozycjaSrodkowa = uporzadkowane.Count() / 2;
       return uporzadkowane.ElementAt(pozycjaSrodkowa);
     }

     public static int? Mediana<T>(
       this IEnumerable<T> sekwencja, Func<T, int?> funkcjaWybierajaca)
     {
       return sekwencja.Select(funkcjaWybierajaca).Mediana();
     }

     public static decimal? Mediana(
       this IEnumerable<decimal?> sekwencja)
     {
       var uporzadkowane = sekwencja.OrderBy(element => element);
       int pozycjaSrodkowa = uporzadkowane.Count() / 2;
       return uporzadkowane.ElementAt(pozycjaSrodkowa);
     }

     public static decimal? Mediana<T>(
       this IEnumerable<T> sekwencja, Func<T, decimal?> funkcjaWybierajaca)
     {
       return sekwencja.Select(funkcjaWybierajaca).Mediana();
     }

     public static int? Dominanta(
       this IEnumerable<int?> sekwencja)
     {
       var pogrupowane = sekwencja.GroupBy(item => item);
       var poszeregowaneGrupy = pogrupowane.OrderByDescending(
         grupa => grupa.Count());
       return poszeregowaneGrupy.FirstOrDefault()?.Key;
     }

     public static int? Dominanta<T>(
       this IEnumerable<T> sekwencja, Func<T, int?> funkcjawybierajaca)
     {
       return sekwencja.Select(funkcjawybierajaca)?.Dominanta();
     }

     public static decimal? Dominanta(
       this IEnumerable<decimal?> sekwencja)
     {
       var pogrupowane = sekwencja.GroupBy(item => item);
       var poszeregowaneGrupy = pogrupowane.OrderByDescending(
         grupa => grupa.Count());
       return poszeregowaneGrupy.FirstOrDefault()?.Key;
     }

     public static decimal? Dominanta<T>(
       this IEnumerable<T> sekwencja, Func<T, decimal?> funkcjawybierajaca)
     {
       return sekwencja.Select(funkcjawybierajaca).Dominanta();
     }
   }
}
