﻿using System.Globalization;

partial class Program
{
   private static void KonfigurujKonsole(string kultura = "pl-PL", bool uzyjKulturyKomputera = false)
   {
      // Pozwala na stosowanie znaków Unicode, takich jak znak Euro.
      OutputEncoding = System.Text.Encoding.UTF8;
      if (!uzyjKulturyKomputera)
      {
         CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo(kultura);
      }
      WriteLine($"CurrentCulture: {CultureInfo.CurrentCulture.DisplayName}");
   }
   private static void WypiszWKolorze(string tekst, ConsoleColor kolor)
   {
      ConsoleColor previousColor = ForegroundColor;
      ForegroundColor = kolor;
      WriteLine(tekst);
      ForegroundColor = previousColor;
   }

   static void TytulSekcji(string tytul)
   {
      WypiszWKolorze($"*** {tytul} ***", ConsoleColor.DarkYellow);
   }
   static void Blad(string komunikat)
   {        
      WypiszWKolorze($"Błąd > {komunikat}", ConsoleColor.Red);
   }

   static void Info(string komunikat)
   {           
      WypiszWKolorze($"Info > {komunikat}", ConsoleColor.Cyan);      
   }
}
