﻿using System.Formats.Tar; // TarFile

try
{
  string aktualny = Environment.CurrentDirectory;
  WypiszInfo($"Aktualny katalog:   {aktualny}");

  string katalogZrodlowy = Path.Combine(aktualny, "obrazy");
  string katalogDocelowy = Path.Combine(aktualny, "rozpakowane");
  string plikTar = Path.Combine(aktualny, "archiwum-obrazow.tar");

  if (!Directory.Exists(katalogZrodlowy))
  {
    WypiszBlad($"Katalog {katalogZrodlowy} musi istnieć. Utwórz go i umieść w nim kilka plików.");
    return;
  }

  if (File.Exists(plikTar))
  {
    // Jeżeli plik Tar już istnieje, to musimy go usunać.
    File.Delete(plikTar);
    WypiszOstrzezenie($"Plik {plikTar} już istniał, więc został usunięty.");
  }

  WypiszInfo(
    $"Archiwizuję katalog: {katalogZrodlowy}\n      do pliku Tar:        {plikTar}");

  TarFile.CreateFromDirectory(
    sourceDirectoryName: katalogZrodlowy,
    destinationFileName: plikTar,
    includeBaseDirectory: true);

  WypiszInfo($"Czy plik {plikTar} istnieje? {File.Exists(plikTar)}.");

  if (!Directory.Exists(katalogDocelowy))
  {
    // Jeżeli katalog docelowy nie istnieje, to musimy go utworzyć
    // zanim zaczniemy wypakowywać archiwum Tar.
    Directory.CreateDirectory(katalogDocelowy);
    WypiszOstrzezenie($"Katalog {katalogDocelowy} jeszcze nie istniał, więc został utworzony.");
  }

  WypiszInfo(
    $"Rozpakowuję archiwum:  {plikTar}\n      do katalogu:        {katalogDocelowy}");

  TarFile.ExtractToDirectory(
    sourceFileName: plikTar,
    destinationDirectoryName: katalogDocelowy,
    overwriteFiles: true);

  if (Directory.Exists(katalogDocelowy))
  {
    foreach (string katalog in Directory.GetDirectories(katalogDocelowy))
    {
      WypiszInfo(
        $"Wypakowany katalog {katalog} zawiera takie pliki: " +
        string.Join(',', Directory.EnumerateFiles(katalog)
          .Select(plik => Path.GetFileName(plik))));
    }
  }
}
catch (Exception ex)
{
  WypiszBlad(ex.Message);
}
