﻿using Biblioteka;

Osoba henryk = new()
{
  Nazwisko = "Henryk",
  DataUrodzenia = new(year: 2001, month: 3, day: 25)
};
henryk.WypiszWKonsoli();


// praca z typami nieganerycznymi
System.Collections.Hashtable wyszukiwanieObiektow = new();

wyszukiwanieObiektow.Add(key: 1, value: "Alpha");
wyszukiwanieObiektow.Add(key: 2, value: "Beta");
wyszukiwanieObiektow.Add(key: 3, value: "Gamma");
wyszukiwanieObiektow.Add(key: henryk, value: "Delta");

int klucz = 2; // szukamy wartości i kluczu 2

WriteLine(format: "Klucz {0} ma wartość: {1}",
  arg0: klucz,
  arg1: wyszukiwanieObiektow[klucz]);

// szukamy wartości o kluczu równym zmiennej henryk
WriteLine(format: "Klucz {0} ma wartość: {1}",
  arg0: henryk,
  arg1: wyszukiwanieObiektow[henryk]);

// praca z typami generycznymi
Dictionary<int, string> slowanikIntString = new();

slowanikIntString.Add(key: 1, value: "Alpha");
slowanikIntString.Add(key: 2, value: "Beta");
slowanikIntString.Add(key: 3, value: "Gamma");
slowanikIntString.Add(key: 4, value: "Delta");

klucz = 3;
WriteLine(format: "Klucz {0} ma wartość: {1}",
  arg0: klucz,
  arg1: slowanikIntString[klucz]);


// Wywoływanie i obsługa zdarzeń
henryk.Krzycz += Henryk_Krzyk;
henryk.Krzycz += Henryk_Krzyk2;

henryk.Szturchnij();
henryk.Szturchnij();
henryk.Szturchnij();
henryk.Szturchnij();


// Porównywanie obiektów podczas sortowania

Osoba?[] osoby =
{
  new() { Nazwisko = "Sianiak" },
  null,
  new() { Nazwisko = "Janiak" },
  new() { Nazwisko = "Adun" },
  new() { Nazwisko = null },
  new() { Nazwisko = "Rykszak" }
};

WypiszNazwiska(osoby, "Początkowa lista osób:");
Array.Sort(osoby);
WypiszNazwiska(osoby, "Do posortowania użyto implementacji interfejsu IComparable w klasie Osoba:");
Array.Sort(osoby, new OsobaComparer());
WypiszNazwiska(osoby, "Do posortowania użyto implementacji interfejsu IComparer w klasie OsobaComparer:");

// Równość typów
int a = 3;
int b = 3;
WriteLine($"a: {a}, b: {b}");
WriteLine($"a == b: {(a == b)}");

Osoba o1 = new() { Nazwisko = "Kevin" };
Osoba o2 = new() { Nazwisko = "Kevin" };
WriteLine($"o1: {o1}, o2: {o2}");
WriteLine($"o1 == o2: {(o1 == o2)}");

Osoba o3 = o1;
WriteLine($"o3: {o3}");
WriteLine($"o1 == o3: {(o1 == o3)}");

WriteLine($"o1.Nazwisko: {o1.Nazwisko }, o2.Nazwisko : {o2.Nazwisko}");
WriteLine($"o1.Nazwisko == o2.Nazwisko: {(o1.Nazwisko == o2.Nazwisko)}");

// praca ze strukturami

WektorPrzesuniecia wp1 = new(3, 5);
WektorPrzesuniecia wp2 = new(-2, 7);
WektorPrzesuniecia wp3 = wp1 + wp2;

WriteLine($"({wp1.X}, {wp1.Y}) + ({wp2.X}, {wp2.Y}) = ({wp3.X}, {wp3.Y})");

WektorPrzesuniecia wp4 = new();
WriteLine($"({wp4.X}, {wp4.Y})");


// dziedziczenie klas

Pracownik jacek = new()
{
  Nazwisko = "Jacek Jankowski",
  DataUrodzenia = new(year: 1990, month: 7, day: 28)
};
jacek.WypiszWKonsoli();

// rozbudowywanie klas

jacek.KodPracownika = "JJ001";
jacek.DataZatrudnienia = new(year: 2014, month: 11, day: 23);
WriteLine($"{jacek.Nazwisko} został zatrudniony {jacek.DataZatrudnienia:dd/MM/yy}");

// pokrywanie elementów klasy

WriteLine(jacek.ToString());

// polimorfizm

Pracownik alicjaJakoPracownik = new()
  { Nazwisko = "Alicja", KodPracownika = "AA123" };

Osoba alicjaJakoOsoba = alicjaJakoPracownik;
alicjaJakoPracownik.WypiszWKonsoli();
alicjaJakoOsoba.WypiszWKonsoli();
WriteLine(alicjaJakoPracownik.ToString());
WriteLine(alicjaJakoOsoba.ToString());

// jawne rzutowanie

if (alicjaJakoOsoba is Pracownik)
{
  WriteLine($"{nameof(alicjaJakoOsoba)} JEST pracownikiem");
  Pracownik alicjaJawnie = (Pracownik)alicjaJakoOsoba;
  // bezpieczna praca z alicjaJawnie
}

Pracownik? alicjaPracownik = alicjaJakoOsoba as Pracownik; // może być null

if (alicjaPracownik is not null)
{
  WriteLine($"{nameof(alicjaJakoOsoba)} JAKO pracownik");
  // pracuj z obiektem alicjaPracownik
}

// Dziedziczenie wyjątków

try
{
  jacek.PodrozWCzasie(kiedy: new(1999, 12, 31));
  jacek.PodrozWCzasie(kiedy: new(1950, 12, 25));
}
catch (WyjatekOsoba ex)
{
  WriteLine(ex.Message);
}

// Używanie metod statycznych do ponownego wykorzystania funkcji

string email1 = "pamela@test.com";
string email2 = "jan&test.com";

WriteLine("{0} to poprawny adres e-mail: {1}",
  arg0: email1,
  arg1: RozszerzeniaDlaString.AdresPoprawny(email1));

WriteLine("{0} to poprawny adres e-mail: {1}",
  arg0: email2,
  arg1: RozszerzeniaDlaString.AdresPoprawny(email2));

WriteLine("{0} to poprawny adres e-mail: {1}",
  arg0: email1,
  arg1: email1.AdresPoprawny());

WriteLine("{0} to poprawny adres e-mail: {1}",
  arg0: email2,
  arg1: email2.AdresPoprawny());


C1 c1 = new() { Nazwisko = "Bartek" };
c1.Nazwisko = "Artur";

C2 c2 = new(Nazwisko: "Bartek");
//c2.Nazwisko = "Artur"; // CS8852: Właściwość niezmienna.

S1 s1 = new() { Nazwisko = "Bartek" };
s1.Nazwisko = "Artur";

S2 s2 = new(Nazwisko: "Bartek");
s2.Nazwisko = "Artur";

S3 s3 = new(Nazwisko: "Bartek");
//s3.Nazwisko = "Artur"; // CS8852: Właściwość niezmienna.