﻿#region Umieszczanie kodu w bloku try-catch

WriteLine("Przed parsowaniem");
Write("Ile masz lat? ");
string? dane = ReadLine();

try
{
  int wiek = int.Parse(dane!);
  WriteLine($"Masz już {wiek} lat.");
}
catch (OverflowException)
{
  WriteLine("Podany wiek jest liczbą, ale jest ona za duża albo za mała.");
}
catch (FormatException)
{
  WriteLine("Podany wiek nie jest liczbą.");
}
catch (Exception ex)
{
  WriteLine($"{ex.GetType()} says {ex.Message}");
}
WriteLine("Parsowanie zakończone");

#endregion

#region Rzucanie wyjątków po przepełnieniu w ramach instrukcji checked

try
{
   checked
   {
      int x = int.MaxValue - 1;
      WriteLine($"Wartość początkowa: {x}");
      x++;
      WriteLine($"Po inkrementacji: {x}");
      x++;
      WriteLine($"Po inkrementacji: {x}");
      x++;
      WriteLine($"Po inkrementacji: {x}");
   }
}
catch (OverflowException)
{
   WriteLine("Wystąpiło przepełnienie, ale złapałem wyjątek.");
}

#endregion

#region Wyłączanie kontroli przepełnień za pomocą instrukcji unchecked

unchecked
{
   int y = int.MaxValue + 1;
   WriteLine($"Wartość początkowa: {y}");
   y--;
   WriteLine($"Po dekrementacji: {y}");
   y--;
   WriteLine($"Po dekrementacji: {y}");
}

#endregion