﻿#region Przechowywanie liczb

// liczba całkowita bez znaku może być wyłącznie dodatnia lub może być zerem
uint liczbaCalkowita = 23;

// liczba całkowita ze znakiem może być dodatnia i ujemna lub może być zerem
int liczbaCalkowitaZeZnakiem = -23;

// float oznacza liczbę zmiennoprzecinkową o pojedynczej precyzji
// Przyrostek F sprawia, że literał jest obsługiwany z typem float.
float liczbaRzeczywista = 2.3F;

// double oznacza liczbę zmiennoprzecinkową o podwójnej precyzji
double innaLiczbaRzeczywista = 2.3;   // literał liczby typu double

#endregion

#region Trzy zmienne przechowujące wartość 2 miliony.
int notacjaDziesietna = 2_000_000;
int notacjaBinarna = 0b_0001_1110_1000_0100_1000_0000;
int notacjaSzesnastkowa = 0x_001E_8480;

#endregion

#region Liczby całkowite

// Sprawdzenie, czy te trzy zmienne przechowują tę samą wartość.
// Obie instrukcje wypisują „true”.
Console.WriteLine($"{notacjaDziesietna == notacjaBinarna}");
Console.WriteLine($"{notacjaDziesietna == notacjaSzesnastkowa}");

// Wypisywanie wartości zmiennych w notacji dziesiętnej.
Console.WriteLine($"{notacjaDziesietna:N0}");
Console.WriteLine($"{notacjaBinarna:N0}");
Console.WriteLine($"{notacjaSzesnastkowa:N0}");

// Wypisywanie wartości zmiennych w notacji szesnastkowej.
Console.WriteLine($"{notacjaDziesietna:X}");
Console.WriteLine($"{notacjaBinarna:X}");
Console.WriteLine($"{notacjaSzesnastkowa:X}");

#endregion

#region Wypisywanie rozmiaru i zakresu wartości różnych typów danych
//-------------------------------------------
Console.WriteLine($"Typ int zajmuje {sizeof(int)} bajtów i może przechowywać liczby z zakresu od { int.MinValue:N0} do { int.MaxValue:N0}.");
Console.WriteLine($"Typ double zajmuje {sizeof(double)} bajtów i może przechowywać liczby z zakresu od { double.MinValue:N0} do { double.MaxValue:N0}.");
Console.WriteLine($"Typ decimal zajmuje {sizeof(decimal)} bajtów i może przechowywać liczby z zakresu od { decimal.MinValue:N0} do { decimal.MaxValue:N0}.");

#endregion

#region Porównanie typów double i decimal

//---------------------------------------
Console.WriteLine("Używanie liczb typu double:");
double a = 0.1;
double b = 0.2;

if (a + b == 0.3)
{
    Console.WriteLine($"{a} + {b} jest równe 0,3");
}
else
{
    Console.WriteLine($"{a} + {b} NIE jest równe 0,3");
}

// --------------------------------------------
Console.WriteLine("Używanie liczb typu decimal:");

decimal c = 0.1M; // M oznacza literał wartości dziesiętnej
decimal d = 0.2M;

if (c + d == 0.3M)
{
    Console.WriteLine($"{c} + {d} jest równe 0.3");
}
else
{
    Console.WriteLine($"{c} + {d} NIE jest równe 0.3");
}

#endregion


#region Specjalne wartości typów float i double

Console.WriteLine($"double.Epsilon: {double.Epsilon}");
Console.WriteLine($"double.Epsilon z 324 miejscami po przecinku: {double.Epsilon:N324}");
Console.WriteLine($"double.Epsilon z 330 miejscami po przecinku: {double.Epsilon:N330}");

const int kol1 = 37;
const int kol2 = 6;
string line = new string('-', kol1 + kol2 + 3);

Console.WriteLine(line);
Console.WriteLine($"{"Wyrażenie",-kol1} | {"Wartość",kol2}");
Console.WriteLine(line);
Console.WriteLine($"{"double.NaN",-kol1} | {double.NaN,kol2}");
Console.WriteLine($"{"double.PositiveInfinity",-kol1} | {double.PositiveInfinity,kol2}");
Console.WriteLine($"{"double.NegativeInfinity",-kol1} | {double.NegativeInfinity,kol2}");
Console.WriteLine(line);
Console.WriteLine($"{"0.0 / 0.0",-kol1} | {0.0 / 0.0,kol2}");
Console.WriteLine($"{"3.0 / 0.0",-kol1} | {3.0 / 0.0,kol2}");
Console.WriteLine($"{"-3.0 / 0.0",-kol1} | {-3.0 / 0.0,kol2}");
Console.WriteLine($"{"3.0 / 0.0 == double.PositiveInfinity",-kol1} | {3.0 / 0.0 == double.PositiveInfinity,kol2}");
Console.WriteLine($"{"-3.0 / 0.0 == double.NegativeInfinity",-kol1} | {-3.0 / 0.0 == double.NegativeInfinity,kol2}");
Console.WriteLine($"{"0.0 / 3.0",-kol1} | {0.0 / 3.0,kol2}");
Console.WriteLine($"{"0.0 / -3.0",-kol1} | {0.0 / -3.0,kol2}");
Console.WriteLine(line);

#endregion

#region Nowe typy liczbowe i kod niebezpieczny

unsafe
{
   Console.WriteLine($"Typ Half zajmuje {sizeof(Half)} bajtów i może przechowywać liczby z zakresu od {Half.MinValue:N0} do {Half.MaxValue:N0}.");
   Console.WriteLine($"Typ Int128 zajmuje {sizeof(Int128)} bajtów i może przechowywać liczby z zakresu od {Int128.MinValue:N0} do {Int128.MaxValue:N0}.");
}

#endregion
