﻿#region Formatowanie za pomocą numerowanych argumentów pozycyjnych

int liczbaJablek = 12;
decimal cenaJablka = 0.35M;

WriteLine(
    format: "{0} jabłek kosztuje {1:C}",
    arg0: liczbaJablek,
    arg1: cenaJablka * liczbaJablek);

string sformatowane = string.Format(
    format: "{0} jabłek kosztuje {1:C}",
    arg0: liczbaJablek,
    arg1: cenaJablka * liczbaJablek);

//ZapiszDoPliku(sformatowane); // Zapisuje ciąg znaków do pliku

// Dla wartości maksymalnie trzech argumentów można używać specjalnych nazw.
WriteLine("{0} {1} mieszkał w {2}.",
  arg0: "Roger", arg1: "Cevung", arg2: "Sztokholmie");

// Przy czterech i więcej argumentów nie można już używać specjalnych nazw.
WriteLine(
  "{0} {1} mieszkał w {2} pracował w zespole {3} w firmie {4}.",
  "Roger", "Cevung", "Sztokholmie", "edukacyjnym", "Optimizely");


#endregion

#region Formatowanie za pomocą interpolowanych ciągów znaków

// W C# 10 i wcześniejszych ta instrukcja musi być zapisana w jednym wierszu.
// W C# 11 i nowszych można w niej stosować znaki końca wiersza.
WriteLine($"{liczbaJablek} jabłek kosztuje {cenaJablka * liczbaJablek:C}");

#endregion

#region Formatowanie ciągów znaków

string tekstJablka = "Jablka";
int liczbaJablek = 1234;
string tekstBanany = "Banany";
int liczbaBananow = 56789;

WriteLine();

WriteLine(format: "{0,-10} {1,6}",
  arg0: "Nazwa", arg1: "Liczba");

WriteLine(format: "{0,-10} {1,6:N0}",
  arg0: tekstJablka, arg1: liczbaJablek);

WriteLine(format: "{0,-10} {1,6:N0}",
  arg0: tekstBanany, arg1: liczbaBananow);

#endregion

#region Pobieranie tekstu od użytkownika

Write("Wpisz swoje imię i naciśnij ENTER: ");
string? imie = ReadLine();

Write("Podaj swój wiek i nciścnij ENTER: ");
string? wiek = ReadLine();

WriteLine(
  $"Cześć {imie}, dobrze wyglądasz jak na {wiek} lat.");

#endregion

#region Odczytywanie naciśniętego klawisza

Write("Naciśnij dowolną kombinację klawiszy: ");
ConsoleKeyInfo klawisz = ReadKey();
WriteLine();
WriteLine("Klawisz: {0}, Znak: {1}, Modyfiktory: {2}",
  arg0: klawisz.Key,
  arg1: klawisz.KeyChar,
  arg2: klawisz.Modifiers);

#endregion