﻿partial class Program
{
   private static void OpoznioneWykonanie(string[] imiona)
   {
      TytulSekcji("Opóźnione wykonanie");

      // Pytanie: Które imiona kończą się na K?
      // (zapisane za pomocą metody rozszerzającej LINQ)
      var zapytanie1 = imiona.Where(imie => imie.EndsWith("k"));

      // Pytanie: Które imiona kończą się na K?
      // (zapisane za pomocą rozszerzonej składni LINQ)
      var zapytanie2 = from imie in imiona where imie.EndsWith("k") select imie;

      // Odpowiedź jako tablica ciągów znaków z wartościami Darek i Tomek
      string[] wynik1 = zapytanie1.ToArray();

      // Odpowiedź jako lista ciągów znaków z wartościami Darek i Tomek
      List<string> wynik2 = zapytanie2.ToList();

      // Odpowiedź jest zwracana w trakcie iterowania po wynikach
      foreach (string imie in zapytanie1)
      {
         WriteLine(imie); // Wypisuje Darek
         imiona[6] = "Tomasz"; // Zmienia Tomek na Tomasz
                               // W drugiej iteracji imię Tomasz nie kończy się literą K
      }

   }

   private static void FiltrowanieZaPomocaWhere(string[] imiona)
   {
      TytulSekcji("Filtrowanie za pomocą metody Where");

      // Jawne tworzenie wymaganego delegata.
      // var zapytanie = imiona.Where(
      //   new Func<string, bool>(ImieDluzszeNizCztery));

      // Kompilator automatycznie tworzy delegata.
      // var zapytanie = imiona.Where(ImieDluzszeNizCztery);

      // Użycie wyrażenia lambda zamiast nazwanej metody.
      IOrderedEnumerable<string> zapytanie = imiona
        .Where(imie => imie.Length > 4)
        .OrderBy(imie => imie.Length)
        .ThenBy(imie => imie);

      foreach (string pozycja in zapytanie)
      {
         WriteLine(pozycja);
      }
   }

   private static bool ImieDluzszeNizCztery(string imie)
   {
      // Zwraca wartość true jeżeli imie jest dłuże niż czetry znaki.
      return imie.Length > 4;
   }

   private static void FiltrowanieWgTypu()
   {
      TytulSekcji("Filtrowanie według typu");

      List<Exception> oczekiwane = new()
    {
      new ArgumentException(), new SystemException(),
      new IndexOutOfRangeException(), new InvalidOperationException(),
      new NullReferenceException(), new InvalidCastException(),
      new OverflowException(), new DivideByZeroException(),
      new ApplicationException()
    };

      IEnumerable<ArithmeticException> zapytanieOWyjatkiArytmetyczne =
        oczekiwane.OfType<ArithmeticException>();

      foreach (ArithmeticException wyjatek in zapytanieOWyjatkiArytmetyczne)
      {
         WriteLine(wyjatek);
      }
   }

   static void PracaZeZbiorami()
   {
      string[] zespol1 = new[] { "Rafał", "Grzegorz", "Jan", "Gabrysia" };

      string[] zespol2 = new[]
        { "Jacek", "Stefan", "Daniel", "Jacek", "Janina" };

      string[] zespol3 = new[]
        { "Darek", "Jacek", "Jacek", "Malina", "Celina" };

      TytulSekcji("Zespoły");

      Wyjscie(zespol1, "Zespół 1");
      Wyjscie(zespol2, "Zespół 2");
      Wyjscie(zespol3, "Zespół 3");

      TytulSekcji("Operacje na zbiorach");

      Wyjscie(zespol2.Distinct(), "zespol2.Distinct():");
      Wyjscie(zespol2.DistinctBy(imie => imie.Substring(0, 2)),
        " zespol2.DistinctBy(imie => imie.Substring(0, 2)):");
      Wyjscie(zespol2.Union(zespol3), "zespol2.Union(zespol3):");
      Wyjscie(zespol2.Concat(zespol3), "zespol2.Concat(zespol3):");
      Wyjscie(zespol2.Intersect(zespol3), "zespol2.Intersect(zespol3):");
      Wyjscie(zespol2.Except(zespol3), "zespol2.Except(zespol3):");
      Wyjscie(zespol1.Zip(zespol2, (c1, c2) => $"{c1} przeciw {c2}"),
        "zespol1.Zip(zespol2):");

   }                            

}
