﻿using System.Xml.Serialization;   // XmlSerializer
using Biblioteka;          // Osoba
using SzybkaJson = System.Text.Json.JsonSerializer;

#region Tworzenie hierarchii obiektów

List<Osoba> osoby = new()
{
   new Osoba(30000M)
   {
      Imie = "Alicja",
      Nazwisko = "Nowak",
      DataUrodzenia = new DateTime(1974, 3, 14)
},
   new Osoba(40000M)
{
      Imie = "Bartosz",
      Nazwisko = "Kowalski",
      DataUrodzenia = new DateTime(1969, 11, 23)
},
   new Osoba(20000M)
{
      Imie = "Celina",
      Nazwisko = "Rozenek",
      DataUrodzenia = new DateTime(1964, 5, 4),
      Dzieci = new()
      {
         new(0M)
         {
            Imie = "Anita",
            Nazwisko = "Rozenek",
            DataUrodzenia = new DateTime(1990, 7, 12)
         }
      }
   }
};

#endregion

#region Serializowanie do formatu XML

TytulSekcji("Serializowanie do formatu XML");

// tworzenie obiektu, który zapisze listę osób do pliku XML
XmlSerializer xs = new(osoby.GetType());

// tworzenie i zapisywanie pliku
string sciezka = Combine(CurrentDirectory, "osoby.xml");

using (FileStream strumien = File.Create(sciezka))
{
   // serializowanie hierarchii obiektów do strumienia
   xs.Serialize(strumien, osoby);
}

WypiszInfoOPliku(sciezka);

#endregion

#region Deserializacja plików XML

TytulSekcji("Deserializacja plików XML");

using (FileStream odczytaneXml = File.Open(sciezka, FileMode.Open))
{
   // deserializacja i rzutowanie hierarchii obiektów
   List<Osoba>? odczytaneOsoby =
      xs.Deserialize(odczytaneXml) as List<Osoba>;

   if (odczytaneOsoby is not null)
   {
      foreach (Osoba os in odczytaneOsoby)
      {
         WriteLine("{0} ma {1} dzieci.",
            os.Nazwisko, os.Dzieci?.Count);
      }
   }
}

#endregion

#region Serializowanie do formatu JSON

TytulSekcji("Serializowanie do formatu JSON");

// tworzenie pliku, do którego będziemy zapisywać
string sciezkaJson = Combine(CurrentDirectory, "osoby.json");

using (StreamWriter strumienJson = File.CreateText(sciezkaJson))
{
   // tworzenie obiektu, który będzie zapisywał dane w formacie JSON
   Newtonsoft.Json.JsonSerializer jss = new();

   // serializowanie hierarchii obiektów do ciągu znaków
   jss.Serialize(strumienJson, osoby);
}

WypiszInfoOPliku(sciezkaJson);

#endregion

#region Deserializowanie plików JSON

TytulSekcji("Deserializowanie plików JSON");

using (FileStream daneJson = File.Open(sciezkaJson, FileMode.Open))
{
   // deserializacja grafu obiektów do typu List<Osoba>
   List<Osoba>? listaOsob =
      await SzybkaJson.DeserializeAsync(utf8Json: daneJson,
        returnType: typeof(List<Osoba>)) as List<Osoba>;

   if (listaOsob is not null)
   {
      foreach (var osoba in listaOsob)
      {
         WriteLine("{0} ma {1} dzieci.",
            osoba.Nazwisko, osoba.Dzieci?.Count ?? 0);
      }
   }
}

#endregion