﻿using Microsoft.CodeAnalysis; 

namespace Biblioteka;

[Generator]
public class GeneratorKoduZrodlowego : ISourceGenerator
{
  public void Execute(GeneratorExecutionContext kontekstWykonania)
  {
    IMethodSymbol? metodaMain = kontekstWykonania.Compilation
      .GetEntryPoint(kontekstWykonania.CancellationToken);
    
    string kodZrodlowy = $@"// Klasa wygenerowana.
#nullable enable

using System.Globalization;

partial class {metodaMain?.ContainingType.Name}
{{
  private static CultureInfo? _kulturaKomputera = null;

  public static void KonfigurujKonsole(
    string kultura = ""pl-PL"",
    bool uzyjKulturyKomputera = false,
    bool pokazKulture = true)
  {{
    // Zapamiętaj kulturę komputera, aby odtworzyć ją później.
    if (_kulturaKomputera is null)
    {{
      _kulturaKomputera = CultureInfo.CurrentCulture;
    }}

    // Pozala stosować znaki specjalne, takie jak symbol Euro.
    OutputEncoding = System.Text.Encoding.UTF8;

    if (uzyjKulturyKomputera)
    {{
      CultureInfo.CurrentCulture = _kulturaKomputera;
    }}
    else
    {{
      CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo(kultura);
    }}

    if (pokazKulture)
    {{
      WriteLine($""Aktualna kultura: {{CultureInfo.CurrentCulture.DisplayName}}."");
    }}
  }}
}}
";

    string nazwaPliku = $"{metodaMain?.ContainingType.Name}.Methods.g.cs";
    kontekstWykonania.AddSource(nazwaPliku, kodZrodlowy);
  }

  public void Initialize(GeneratorInitializationContext kontekstInicjalizacji)
  {
    // Ten generator kodu nie wymaga żadnej inicjalizacji.
  }
}
