﻿using Biblioteka;  // Ksiazka
using System.Text.Json; // JsonSerializer

Ksiazka mojaksiazka = new(tytul:
  "C# 12 i .NET 8 dla programistów aplikacji wieloplatformowych")
{
   Autor = "Mark J Price",
   DataPublikacji = new(year: 2023, month: 11, day: 14),
   LiczbaStron = 823,
   Utworzone = DateTimeOffset.UtcNow,
};

JsonSerializerOptions opcje = new()
{
   IncludeFields = true, // Dołącza wszystkie pola
   //PropertyNameCaseInsensitive = true,
   //WriteIndented = true,
   //PropertyNamingPolicy = JsonNamingPolicy.CamelCase,
};

string sciezkaPliku = Combine(CurrentDirectory, "ksiazka.json");

using (Stream strumienPliku = File.Create(sciezkaPliku))
{
   JsonSerializer.Serialize<Ksiazka>(
     utf8Json: strumienPliku, value: mojaksiazka, opcje);
}

WriteLine("**** Informacje o pliku ****");
WriteLine($"Plik: {GetFileName(sciezkaPliku)}");
WriteLine($"Ścieżka: {GetDirectoryName(sciezkaPliku)}");
WriteLine($"Wielkość: {new FileInfo(sciezkaPliku).Length:N0} bajtów.");
WriteLine("/------------------");
WriteLine(File.ReadAllText(sciezkaPliku));
WriteLine("------------------/");
