using Northwind.ModeleEncji; // KontekstNorthwind.

namespace Northwind.TestyJednostkowe;

public class ModeleEncjiTesty
{
  [Fact]
  public void PolaczenieDazyDanychTest()
  {
    using KontekstNorthwind db = new();
    Assert.True(db.Database.CanConnect());
  }

  [Fact]
  public void LiczbaKategoriiTest()
  {
    using KontekstNorthwind db = new();

    int oczekiwane = 8;
    int faktyczne = db.Categories.Count();

    Assert.Equal(oczekiwane, faktyczne);
  }

  [Fact]
  public void ProduktId1ToChaiTest()
  {
    using KontekstNorthwind db = new();

    string oczekiwane = "Chai";

    Product? produkt = db.Products.Find(keyValues: 1);
    string faktyczne = produkt?.ProductName ?? string.Empty;

    Assert.Equal(oczekiwane, faktyczne);
  }
}