﻿using System.Xml; // XmlWriter, XmlWriterSettings
using static System.Environment;
using static System.IO.Path;



TytulSekcji("Praca z tekstem");

// definiuje plik, z którym będziemy pracować
string plikTekstowy = Combine(CurrentDirectory, "strumienie.txt");

// tworzenie pliku tekstowego zwraca klasę pomocniczą
StreamWriter tekst = File.CreateText(plikTekstowy);

// przejdź w pętli wszystkie wywołania i wypisz je
// w pliku, każde w osobnym wierszu
foreach (string wywolanie in Viper.wywolania)
{
  tekst.WriteLine(wywolanie);
}
tekst.Close(); // zwolnij zasoby

// wypisz zawartość pliku w konsoli
WriteLine("{0} ma wielkość {1:N0} bajtów.",
  arg0: plikTekstowy,
  arg1: new FileInfo(plikTekstowy).Length);

WriteLine(File.ReadAllText(plikTekstowy));


TytulSekcji("Praca ze strumieniami XML");

FileStream strumienPlikuXml = null;
XmlWriter xml = null;

try
{
  // definiowanie pliku, do którego będziemy zapisywać
  string plikXml = Combine(CurrentDirectory, "strumienie.xml");

  // utworzenie strumienia do pliku
  strumienPlikuXml = File.Create(plikXml);

  // opakowanie strumienia pliku w obiekt pomocniczy,
  // zapisujący dane XML i automatycznie tworzący wcięcia
  xml = XmlWriter.Create(strumienPlikuXml,
	 new XmlWriterSettings { Indent = true });

  // zapisanie deklaracji XML
  xml.WriteStartDocument();

  // zapisanie elementu bazowego
  xml.WriteStartElement("wywolania");

  // wypisywanie w pętli wszystkich wywołań z tablicy
  foreach (string wywolanie in Viper.wywolania)
  {
	 xml.WriteElementString("wywolanie", wywolanie);
  }

  // zapisanie zamknięcia elementu bazowego
  xml.WriteEndElement();

  // zamknięcie obiektu pomocniczego i strumienia
  xml.Close();
  strumienPlikuXml.Close();

  // wypisanie zawartości pliku w konsoli
  WriteLine("{0} ma wielkość {1} bajtów.",
	 arg0: plikXml,
	 arg1: new FileInfo(plikXml).Length);

  WriteLine(File.ReadAllText(plikXml));
}
catch (Exception ex)
{
  // jeżeli ścieżka nie istnieje, to rzucony wyjątek zostanie tutaj złapany
  WriteLine($"{ex.GetType()} says {ex.Message}");
}
finally
{
  if (xml != null)
  {
	 xml.Dispose();
	 WriteLine("Niezarządzane zasoby obiektu pomocniczego zostały zwolnione.");
	 if (strumienPlikuXml != null)
	 {
		strumienPlikuXml.Dispose();
		WriteLine("Niezarządzane zasoby strumienia zostały zwolnione.");
	 }
  }
}



