﻿using Microsoft.EntityFrameworkCore; 
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.EntityFrameworkCore.ChangeTracking; // CollectionEntry
using Microsoft.EntityFrameworkCore.Storage; // IDbContextTransaction

using BibliotekaWspolna;

Northwind db = new();
WriteLine($"Dostawca: {db.Database.ProviderName}");

ZapytanieOKategorie();
// FiltrowanieDolaczen();
// ZapytanieOProdukty();
// ZapytanieZLike();
//PobierzLosowyProdukt

var wynikDodania = DodajProdukt(IdKategorii: 6, 
   nazwaProduktu: "Burgery Boba", cena: 500M)

if (wynikDodania.zmienione == 1)
{
   WriteLine("Dodano nowy produkt z identyfikatorem: {wynikDodania.productId}.");
}

WypiszProdukty(idProduktowDoWyroznienia: wynikDodania.productId);


var wynikAktualizacji = ZwiekszCeneProduktu(
   poczatekNazwy: "Burg", kwota: 20M);

if (wynikAktualizacji.zmienione == 1)
{
   WriteLine("Udało się zmienić cenę produktu o ID: {wynikAktualizacji.idProduktu}.");
}
WypiszProdukty(produktyDoWyroznienia: new[] { wynikAktualizacji.IdProduktu});


WriteLine("Zaraz usunę wszystkie produkty o nazwie zaczynającej się od Burg.");
Write("Naciśnij Enter, aby kontynuować, albo inny klawisz, aby przerwać: ");
if (ReadKey(intercept: true).Key == ConsoleKey.Enter)
{
   int usuniete = DeleteProducts(productNameStartsWith: "Burg");
   WriteLine($"Usunieto {usuniete} produktów.");
}
else
{
   WriteLine("Usuwanie zostało odwołane.");
}


var wynikLepszejAktualizacji = SzybkszeZwiekszanieCenProduktow (
  poczatekNazwy: "Burg", kwota: 20M);

if (wynikLepszejAktualizacji.zmienione > 0)
{
  WriteLine("Udało się zwiększyć ceny produktów.");
}
WypiszProdukty(IdProduktowDoWyroznienia: wynikLepszejAktualizacji.idProduktow);


WriteLine("Zaraz usunę wszystkie produkty o nazwach zaczynających się od Burg.");
Write("Naciśnij Enter, aby kontynuować, albo inny klawisz, aby zakończyć: ");
if (ReadKey(intercept: true).Key == ConsoleKey.Enter)
{
  int usuniete = LepszeUsuwanieProduktow(poczatekNazwy: "Burg");
  WriteLine($"Usunięto {usuniete} produktów.");
}
else
{
  WriteLine("Usuwanie zostało odwołane.");
}
