using System.IO.Compression;  // BrotliStream, GZipStream, CompressionMode
using System.Xml; // XmlWriter, XmlReader

using static System.Environment; // CurrentDirectory
using static System.IO.Path; // Combine

partial class Program
{
  static void Kompresuj(string algorytm = "gzip")
  {
    // definiowanie nazwy pliku, w którym rozszerzenie jest nazwą algorytmu
    string sciezkaDoPliku = Combine(
      CurrentDirectory, $"strumienie.{algorytm}");

    FileStream plik = File.Create(sciezkaDoPliku);
    Stream kompresor;
    if (algorytm == "gzip")
    {
      kompresor = new GZipStream(plik, CompressionMode.Compress);
    }
    else
    {
      kompresor = new BrotliStream(plik, CompressionMode.Compress);
    }


    using (kompresor)
    {
      using (XmlWriter xml = XmlWriter.Create(kompresor))
      {
        xml.WriteStartDocument();
        xml.WriteStartElement("wywolania");
        foreach (string wywolanie in Viper.wywolania)
        {
           xml.WriteElementString("wywolanie", wywolanie);
        }
    }
  } // zamyka też podstawowy strumień

  // wypisanie zawartości skompresowanego pliku w konsoli
  WriteLine($"{0} ma wielkość {1} bajtów.",
     0, new FileInfo (sciezkaDoPliku).Length);

  WriteLine("Skompresowana zawartość pliku:");
  WriteLine(File.ReadAllText(sciezkaDoPliku));

  // odczytanie skompresowanego pliku
  WriteLine("Odczytuję skompresowany plik XML:");
  plik = File.Open(sciezkaDoPliku, FileMode.Open);
  Stream dekompresor;
  if (algorytm == "gzip")
  {
    dekompresor = new GzipStream(plik, CompressionMode.Decompress);
  }
  else
  {
    dekompresor = new BrotliStream(plik, CompressionMode.Decompress);
  }

  using (dekompresor)
  {
    using (XmlReader odczyt = XmlReader.Create(dekompresor))
    {
      while (odczyt.Read())
      {
        // sprawdzenie, czy aktualnie jesteśmy w węźle o nazwie 'wywolanie'
        if ((reader.NodeType == XmlNodeType.Element) 
          && (reader.Name == "wywolanie"))
        {
          reader.Read(); // przejście do węzła tekstowego w ramach elementu
          WriteLine($"{reader.Value}"); // odczytanie wartości węzła
        }
      }
    }
  }
}
