﻿using Microsoft.EntityFrameworkCore; // UseSqlServer
using Microsoft.Extensions.DependencyInjection; // IServiceCollection

namespace BibliotekaWspolna;

public static class NorthwindContextExtensions
{
   /// <summary>
   /// Dodaje obiekt typu NorthwindContext do wskazanej kolekcji
   /// IServiceCollection. Używa dostawcy danych SqlServer.
   /// </summary>
   /// <param name="serwisy"></param>
   /// <param name="polaczenie">Przypisz wartość, aby zmienić domyślną.</param>
   /// <returns>Kolekcja typu IServiceCollection, której można użyć do dodawania
   /// kolejnych serwisów.</returns>
   public static IServiceCollection AddNorthwindContext(
    this IServiceCollection serwisy, string polaczenie = 
      "Data Source=.;Initial Catalog=Northwind;"
      + "Integrated Security=true;MultipleActiveResultsets=true;")
  {
    serwisy.AddDbContext<NorthwindContext>(opcje =>
      opcje.UseSqlServer(polaczenie)
      .UseLoggerFactory(new ConsoleLoggerFactory())
    );

    return serwisy;
  }
}
