﻿using Microsoft.EntityFrameworkCore; // GenerateCreateScript()
using UczniowieIKursy; // Akademia

using (Akademia a = new())
{
  bool deleted = await a.Database.EnsureDeletedAsync();
  WriteLine($"Usunięto bazę danych: {deleted}");

  bool created = await a.Database.EnsureCreatedAsync();
  WriteLine($"Utworzono bazę danych: {created}");

  WriteLine("Skrypt SQL użyty do utworzenia bazy danych:");
  WriteLine(a.Database.GenerateCreateScript());

  foreach (Uczen s in a.Uczniowie.Include(s => s.Kursy))
  {
    WriteLine("{0} {1} uczęszcza na {2} kursy:",
      s.Imie, s.Nazwisko, s.Kursy.Count);

    foreach (Kurs c in s.Kursy)
    {
      WriteLine($"  {c.Nazwa}");
    }
  }
}
