using Northwind.Wspolne; // Pogodynka

var builder = WebApplication.CreateBuilder(args);

builder.WebHost.UseUrls("https://localhost:5003");

builder.Services.AddCors();

var app = builder.Build();

// pozwalaj wyłącznie na klienta MVC i jedynie na żądania GET
app.UseCors(configurePolicy: opcje =>
{
  opcje.WithMethods("GET");
  opcje.WithOrigins("https://localhost:5001"
  );
});

app.MapGet("/api/pogoda", () => 
{
  return Enumerable.Range(1, 5).Select(indeks =>
    new Pogodynka
    {
      Data = DateTime.Now.AddDays(indeks),
      TemperaturaC = Random.Shared.Next(-20, 55),
      Podsumowanie = Pogodynka.Podsumowania[
        Random.Shared.Next(Pogodynka.Podsumowania.Length)]
    })
    .ToArray();
});

app.Run();
