﻿using System.Net.Mail;

namespace Synchronization;

static class EventObjects
{
    static void LogFailure(string message, string mailServer)
    {
        var email = new SmtpClient(mailServer);

        using (var emailSent = new ManualResetEvent(false))
        {
            object sync = new();
            bool tooLate = false; // Uniemożliwiamy wywoływanie metody Set po upłynięciu 
                                  // limitu czasu    
            email.SendCompleted += (_, _) =>
            {
                lock (sync)
                {
                    if (!tooLate) { emailSent.Set(); }
                }
            };
            email.SendAsync("logger@example.com", "sysadmin@example.com",
                "Zgłoszenie awarii", "Wystąpił błąd: " + message, null);

            LogPersistently(message);

            if (!emailSent.WaitOne(TimeSpan.FromMinutes(1)))
            {
                LogPersistently("Upłynął limit czasu wysyłania wiadomości: " + message);
            }

            lock (sync)
            {
                tooLate = true;
            }
        }
    }

    private static void LogPersistently(string message)
    {
        // Tylko do celów demonstracyjnych
    }
}
