﻿using LibraryContainingCustomComparer;

static IComparer<string> GetComparer(bool useStandardOrdering)
{
    if (useStandardOrdering)
    {
        return StringComparer.CurrentCulture;
    }
    else
    {
        return new MyCustomComparer();
    }
}

IComparer<string> c = GetComparer(useStandardOrdering: true);

// LibraryContainingCustomComparer będzie już wczytany, choć nie używamy 
// niestandardowego komparatora, który definiuje

Console.WriteLine(c.Compare("jabłka", "pomarańcze"));