# Rozdział 9. - Przykłady

Przykłady z rozdziału 9. (Delegaty, wyrażenia lambda i zdarzenia) książki C# 10.0. Programowanie

* [Listing 1. Przeszukiwanie tablicy przy wykorzystaniu delegata](DelegatyLambdyZdarzenia/Delegates/Program.cs#L11-L14)

## Typy delegatów

* [Listing 2. Metoda z parametrem typu delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L19-L21)
* [Listing 3. Typ delegatu Predicate<T>](DelegatyLambdyZdarzenia/Delegates/Program.cs#L23)
* [Listing 4. Tworzenie delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L46)
* [Listing 5. Konstruowanie delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L53)
* [Listing 6. Niejawne tworzenie delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L60)
* [Listing 7. Delegaty do metod zdefiniowanych w innej klasie](DelegatyLambdyZdarzenia/DelegatesOtherClass/Program.cs#L3-L17)
* [Listing 8. Niejawne delegaty instancji](DelegatyLambdyZdarzenia/Delegates/ThresholdComparer.cs#L3-L10)
* [Listing 9. Jawne delegaty instancji](DelegatyLambdyZdarzenia/Delegates/Program.cs#L67-L73)
* [Listing 10. Zastosowanie metody CreateDelegate](DelegatyLambdyZdarzenia/Delegates/Program.cs#L91-L93)
* [Listing 11. Łączenie delegatów](DelegatyLambdyZdarzenia/Delegates/Program.cs#L79-L84)
* [Listing 12. Wywoływanie delegatów](DelegatyLambdyZdarzenia/Delegates/Program.cs#L98-L102)
* [Listing 13. Pierwsze cztery delegaty Action](DelegatyLambdyZdarzenia/Delegates/Program.cs#L25-L28)
* [Listing 14. Kilka pierwszych delegatów Func](DelegatyLambdyZdarzenia/Delegates/Program.cs#L30-L34)
* [Listing 15. Kowariancja delegatów](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L5-L15)
* [Listing 16. Niedozwolona konwersja delegatów](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L22-L23)
* [Listing 17. Składowe typu delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L36-L41)
* [Listing 18. Jawne stosowanie metody Invoke](DelegatyLambdyZdarzenia/Delegates/ExplicitInvoke.cs#L5-L9)
* [Listing 19. Zastosowanie metody Invoke wraz z operatorem warunkowych wartości pustych](DelegatyLambdyZdarzenia/Delegates/ConditionalInvoke.cs#L5-L8)

## Funkcje anonimowe

* [Listing 20. Składnia metody anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/AnonymousMethodSyntax.cs#L7-L13)
* [Listing 21. Składnia wyrażeń lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L5-L11)
* [Listing 22. Różne sposoby zapisu wyrażeń lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L15-L24)
* [Listing 23. Bezargumentowe wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L36)
* [Listing 24. Ignorowanie argumentów w metodzie anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/AnonymousMethodSyntax.cs#L17)
* [Listing 25. Wyrażenie lambda ignorujące swoje argumenty](DelegatyLambdyZdarzenia/AnonymousFunctions/AnonymousMethodSyntax.cs#L24)
* [Listing 26. Korzystanie ze zmiennych dostępnych w metodzie zawierającej wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L5-L8)
* [Listing 27. Użycie zmiennej z metody zawierającej wyrażenie lambda (w formie wyrażenia) (expression-bodied)xxxx](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethodExpressionBodied.cs#L5-L6)
* [Listing 28. Skąd pochodzi argument value](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethodExpressionBodied.cs#L10-L11)
* [Listing 29. Wygenerowany kod funkcji anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L13-L22)
* [Listing 30. Modyfikacja przechwyconej zmiennej](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L24-L43)
* [Listing 31. Przedwczesne zwolnienie zasobów](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L47-L52)
* [Listing 32. Odrzucanie przechwytywania przy użyciu słowa kluczowego static](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L94)
* [Listing 33. Problematyczne przechwytywanie zmiennych w pętli for](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L57-L67)
* [Listing 34. Modyfikacja pętli w celu przechwytywania aktualnej wartości licznika](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L72-L76)
* [Listing 35. Przechwytywanie zmiennych o różnym zakresie](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L86-L91)
* [Listing 36. Wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/ExpressionTrees.cs#L9)
* [Listing 37. Co kompilator robi z wyrażeniem lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/ExpressionTrees.cs#L14-L18)
* [Listing 38. Wyrażenia i zapytania do baz danych](DelegatyLambdyZdarzenia/AnonymousFunctions/DataAccess.cs#L12)
* [Listing 39. Użycie wyrażeń lambda w bibliotece Moq](DelegatyLambdyZdarzenia/AnonymousFunctions/MoqLambdas.cs#L9-L12)

## Zdarzenia

* [Listing 40. Klasa ze zdarzeniem](DelegatyLambdyZdarzenia/Events/Eventful.cs#L3-L11)
* [Listing 41. Obsługa zdarzeń](DelegatyLambdyZdarzenia/Events/Program.cs#L7-L8)
* [Listing 42. W jaki sposób nie należy zgłaszać zdarzeń](DelegatyLambdyZdarzenia/Events/Program.cs#L16-L17)
* [Listing 43. Przybliżony efekt deklaracji zdarzenia](DelegatyLambdyZdarzenia/Events/RouglyHowEventsWork.cs#L6-L18)
* [Listing 44. Typ delegatu EventHandler](DelegatyLambdyZdarzenia/Events/Program.cs#L25)
* [Listing 45. Niestandardowe metody dodające i usuwające sporadycznie obsługiwane zdarzenia](DelegatyLambdyZdarzenia/Events/ScarceEventSource.cs#L3-L80)
