# Rozdział 7. - Przykłady

Przykłady z rozdziału 7. (Cykl życia obiektów) książki C# 10.0. Programowanie

## Mechanizm odzyskiwania pamięci

* [Listing 1. Używanie i usuwanie obiektów](CyklZyciaObiektow/GarbageCollection/UsingAndDiscarding.cs#L7-L13)
* [Listing 2. Okropnie nieefektywny fragment kodu](CyklZyciaObiektow/GarbageCollection/Program.cs#L5-L16)
* [Listing 3. Stosowanie słabych referencji do obsługi pamięci podręcznej](CyklZyciaObiektow/WeakRefs/WeakCache.cs#L5-L34)
* [Listing 4. Sprawdzanie działania klasy korzystającej ze słabych referencji](CyklZyciaObiektow/WeakRefs/Program.cs#L5-L51)
* [Listing 5. Nieduży obiekt z wielką tablicą](CyklZyciaObiektow/GarbageCollection/GreedyObject.cs#L3-L6)
* [Listing 6. Włączanie trybu serwerowego w pliku projektu aplikacji .NET Core](CyklZyciaObiektow/NetCoreServerGc/NetCoreServerGc.csproj#L10-L12)

## Destruktory i finalizacja

* [Listing 7. Klasa definiująca destruktor](CyklZyciaObiektow/GarbageCollection/LetMeKnowMineEnd.cs#L3-L9)

# Interfejs IDisposable

* [Listing 8. Interfejs IDisposable](CyklZyciaObiektow/Disposable/Program.cs#L13-L16)
* [Listing 9. Instrukcja using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L7-L10)
* [Listing 10. Pełny odpowiednik wykorzystania instrukcji using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L18-L31)
* [Listing 11. Deklaracja using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L36-L37)
* [Listing 12. Sekwencja instrukcji using](CyklZyciaObiektow/Disposable/UsingStatements.cs#L42-L46)
* [Listing 13. Pętla foreach](CyklZyciaObiektow/Disposable/ForeachDisposal.cs#L7-L10)
* [Listing 14. Pełne rozwinięcie pętli foreach](CyklZyciaObiektow/Disposable/ForeachDisposal.cs#L14-L32)
* [Listing 15. Zwalnianie obiektu przechowywanego w polu innego obiektu](CyklZyciaObiektow/Disposable/Logger.cs#L3-L21)
* [Listing 16. Niestandardowa logika finalizacji i zwalniania](CyklZyciaObiektow/Disposable/MyFunkyStream.cs#L3-L29)

## Pakowanie

* [Listing 17. Użycie danej typu int jako obiektu](CyklZyciaObiektow/Boxing/Program.cs)
* [Listing 18. W rzeczywistości nie tak działa pakowanie](CyklZyciaObiektow/Boxing/Box.cs#L3-L16)
* [Listing 19. Rozpakowywanie wartości z użyciem wzorca typu](CyklZyciaObiektow/Boxing/Unboxing.cs#L7-L10)
* [Listing 20. Ilustracja pułapek zmiennych struktur](CyklZyciaObiektow/MutableStructPitfalls/Program.cs)
* [Listing 21. Rozpakowanie wartości int do zmiennej typu int oraz typu dopuszczającego wartość pustą](CyklZyciaObiektow/Boxing/Unboxing.cs#L15-L18)