﻿namespace Disposable;

public static class UsingStatements
{
    public static void UsingUsing()
    {
        using (StreamReader reader = File.OpenText(@"C:\temp\File.txt"))
        {
            Console.WriteLine(reader.ReadToEnd());
        }
    }

    public static void TheEffectOfUsing()
    {
        // Dodatkowa para nawiasów klamrowych została zastosowana celowo - pozwala
        // zademonstrować, że instrukcja using wprowadza dodatkowy zakres oraz 
        // że zmienna podana w deklaracji instrukcji using jest dostępna wyłącznie 
        // w tym zakresie
        {
            StreamReader reader = File.OpenText(@"C:\temp\File.txt");
            try
            {
                Console.WriteLine(reader.ReadToEnd());
            }
            finally
            {
                if (reader != null)
                {
                    ((IDisposable)reader).Dispose();
                }
            }
        }
    }

    public static void UsingDeclaration()
    {
        using StreamReader reader = File.OpenText(@"C:\temp\File.txt");
        Console.WriteLine(reader.ReadToEnd());
    }

    public static void StackedUsingStatements()
    {
        using (Stream source = File.OpenRead(@"C:\temp\File.txt"))
        using (Stream copy = File.Create(@"C:\temp\Copy.txt"))
        {
            source.CopyTo(copy);
        }
    }
}
