# Rozdział 4. - Przykłady

Przykłady z rozdziału 4. (Typy ogólne) książki C# 10.0. Programowanie

## Typy ogólne

* [Listing 1. Definiowanie klasy ogólnej](TypyOgolne/GenericTypes/NamedContainer.cs#L3-L13)
* [Listing 2. Definicja rekordu ogólnego](TypyOgolne/GenericTypes/NamedContainerRecord.cs#L3)
* [Listing 3. Stosowanie klasy ogólnej](TypyOgolne/GenericTypes/Program.cs#L16-L18)
* [Listing 4. Skonstruowane typy ogólne zastosowane jako argumenty typu](TypyOgolne/GenericTypes/Program.cs#L20-L22)

## Ograniczenia

* [Listing 5. Tworzenie nowej instancji typu parametrycznego](TypyOgolne/Constraints/Deferred.cs#L3-L20)
* [Listing 6. Stosowanie ograniczeń typu](TypyOgolne/Constraints/GenericComparer.cs#L3-L11)
* [Listing 7. Tego kodu nie można skompilować: interfejs nie został zaimplementowany](TypyOgolne/Constraints/GenericComparer.cs#L17-L24)
* [Listing 8. Tego kodu nie można skompilować: brak ograniczenia](TypyOgolne/Constraints/GenericComparer.cs#L26-L33)
* [Listing 9. Ograniczenie określające, że jeden argument ma być typem pochodnym drugiego](TypyOgolne/Constraints/Foo.cs#L3-L4)
* [Listing 10. Ograniczenie wymagające typu referencyjnego](TypyOgolne/Constraints/Bar.cs#L3-L4)
* [Listing 11. Ograniczenie narzucone przez inne ograniczenie](TypyOgolne/Constraints/TestBase.cs#L3-L19)
* [Listing 12. Ograniczenie wymuszające użycie typu wartościowego](TypyOgolne/Constraints/Quux.cs#L3-L4)
* [Listing 13. Ograniczenia wymagające typu delegatu i typu wyliczeniowego](TypyOgolne/Constraints/DelegateAndEnumConstraints.cs#L3-L11)
* [Listing 14. Stosowanie wielu ograniczeń](TypyOgolne/Constraints/Spong.cs#L3-L4)

## Wartości przypominające zero

* [Listing 15. Pobieranie wartości domyślnej argumentu typu](TypyOgolne/ZeroLike/Program.cs#L11-L14)
* [Listing 16. Pobieranie domyślnej (zerowej) wartości wywnioskowanego typu](TypyOgolne/ZeroLike/Program.cs#L16)

## Metody ogólne

* [Listing 17. Metoda ogólna](TypyOgolne/GenericMethods/Program.cs#L16)
* [Listing 18. Wywoływanie metody ogólnej](TypyOgolne/GenericMethods/Program.cs#L9-L10)
* [Listing 19. Metoda ogólna ze zdefiniowanymi ograniczeniami](TypyOgolne/GenericMethods/Program.cs#L18-L22)
* [Listing 20. Wnioskowanie argumentu typu metody ogólnej](TypyOgolne/GenericMethods/Program.cs#L26-L27)

## Typy ogólne i krotki

* [Listing 21. Deklarowanie zmiennej krotki w standardowy sposób](TypyOgolne/GenericsAndTuples/Program.cs#L3)
* [Listing 22. Deklarowanie zmiennej krotki przy użyciu jej faktycznego typu](TypyOgolne/GenericsAndTuples/Program.cs#L5)
* [Listing 23. Zwracanie krotki](TypyOgolne/GenericsAndTuples/ReturnTuple.cs#L5)

## Tajniki typów ogólnych

* [Listing 24. Jedna z możliwości szablonów, której nie można odtworzyć w typach ogólnych C#](TypyOgolne/GenericMethods/Program.cs#L35-L38)
