# Rozdział 16. - Przykłady

Przykłady z rozdziału 16. (Wielowątkowość) książki C# 10.0. Programowanie

## Wątki

* [Listing 1. Widoczność obiektu i metody](Wielowatkowosc/Threading/ObjectVisibility.cs#L7-L18)
* [Listing 2. Niebezpieczne pod względem pracy wielowątkowej użycie bezpiecznej kolekcji](Wielowatkowosc/Threading/NonThreadSafeUseOfThreadSafeCollection.cs#L7-L11)
* [Listing 3. Zastosowanie klasy ThreadLocal&lt;T&gt;](Wielowatkowosc/Threading/Notifier.cs#L3-L31)
* [Listing 4. Tworzenie wątków](Wielowatkowosc/CreatingThreads/Program.cs#L3-L28)
* [Listing 5. Uruchamianie kodu w puli wątków przy wykorzystaniu klasy Task](Wielowatkowosc/Threading/TaskThreadPool.cs#L9)
* [Listing 6. Stosowanie puli wątków oraz klasy SynchronizationContext](Wielowatkowosc/ThreadAffinity/MainWindow.xaml.cs#L16-L41)
* [Listing 7. Korzystanie z klasy ExecutionContext](Wielowatkowosc/ThreadAffinity/Defer.cs#L3-L26)

## Synchronizacja

* [Listing 8. Zabezpieczanie stanu przy użyciu słowa kluczowego lock](Wielowatkowosc/Synchronization/SaleLog.cs#L3-L40)
* [Listing 9. Sposób przetwarzania bloku instrukcji lock](Wielowatkowosc/Synchronization/EquivalentOfLock.cs#L46-L62)
* [Listing 10. Zastosowanie metod Wait oraz Pulse](Wielowatkowosc/Synchronization/MessageQueue.cs#L3-L33)
* [Listing 11. Zabezpieczanie dostępu do danych typu decimal przy użyciu klasy SpinLock](Wielowatkowosc/Synchronization/DecimalTotal.cs#L3-L45)
* [Listing 12. Oczekiwanie na wykonanie operacji przy użyciu klasy ManualResetEvent](Wielowatkowosc/Synchronization/EventObjects.cs#L7-L37)
* [Listing 13. Zastosowanie metody CompareExchange](Wielowatkowosc/Synchronization/UsingCompareExchange.cs#L5-L16)
* [Listing 14. Zastosowanie klasy LazyInitializer](Wielowatkowosc/Synchronization/Cache.cs#L3-L9)

## Zadania


* [Listing 15. Pobieranie kodu strony WWW przy wykorzystaniu zadań](Wielowatkowosc/Tpl/Program.cs#L7-L9)
* [Listing 16. Pobieranie wyniku zadania przy użyciu słowa kluczowego await](Wielowatkowosc/Tpl/Program.cs#L11)
* [Listing 17. Kontynuacja](Wielowatkowosc/Tpl/Program.cs#L14-L18)
* [Listing 18. Anulowanie i sekwencja kontynuacji](Wielowatkowosc/Tpl/Program.cs#L22-L38)
* [Listing 19. Planowanie wykonania kontynuacji w wątku obsługi interfejsu użytkownika](Wielowatkowosc/TplSchedulers/MainWindow.xaml.cs#L9-L33)
* [Listing 20. Zastosowanie klasy TaskCompletionSource&lt;T&gt;](Wielowatkowosc/Tpl/SmtpAsyncExtensions.cs#L6-L37)
* [Listing 21. Para metod APM oraz odpowiadająca im metoda synchroniczna](Wielowatkowosc/Tpl/Program.cs#L43-L47)
* [Listing 22. Równoległe obliczanie splotu](Wielowatkowosc/Tpl/ParallelFor.cs#L5-L19)
