﻿using System.Text;
using System.Xml;

using (var fw = new StreamWriter(@"c:\temp\out.txt"))
{
    fw.WriteLine($"Writing to a file at {DateTime.Now}");
}

string xmlContent =
    "<message><text>Hello</text><recipient>world</recipient></message>";
var xmlReader = XmlReader.Create(new StringReader(xmlContent));
while (xmlReader.Read())
{
    if (xmlReader.NodeType == XmlNodeType.Text)
    {
        Console.WriteLine(xmlReader.Value);
    }
}

using (var sw = new StreamWriter("Text.txt", false,
                        Encoding.GetEncoding(1252)))
{
    sw.Write("£100");
}

// Składowe klasy StreamReader zamieszczone tylko w celach demonstracyjnych. Klasa ta jest
// zdefiniowana w .NET, więc nie musimy jej definować samodzielnie.

#if false
public virtual int Read(char[] buffer, int index, int count) { ... }
public virtual int ReadBlock(char[] buffer, int index, int count) { ... }
#endif
